/*=======================================================================+
 |  Copyright (c) 1999 Oracle Corporation Redwood Shores, California, USA|
 |                            All rights reserved.                       |
 +=======================================================================+
 | FILENAME
 |      AFWFSFNSS.pls
 | DESCRIPTION
 |      PL/SQL spec for package:  FND_FUNCTION
 |      
 |      This package is pseudo package in standalone install.
 |      The real FND_FUNCTION would be used in Apps install.
 +======================================================================*/

whenever sqlerror exit failure rollback;

create or replace package FND_FUNCTION as
/* $Header: AFWFSFNS.pls 26.1 2004/01/01 01:34:38 dlam ship $ */

--
-- TEST
--   Test if function is accessible under current responsibility.
-- IN
--   function_name - function to test
-- RETURNS
--  TRUE if function is accessible
--
function TEST(function_name in varchar2) return boolean;
pragma restrict_references (TEST, WNDS, WNPS);

--
-- Function get_function_id
--      returns the function id for a function name.
-- in: p_function_name- the developer function name to look up
-- returns: the function id, or NULL if it can't be found.
------------------------------
Function get_function_id(p_function_name in varchar2
                       ) return number;

end FND_FUNCTION;
/
commit;
exit;



