REM dbdrv: none
/*=======================================================================+
 |        Copyright (c) 1995, 2004, Oracle.  All rights reserved.        |
 +=======================================================================+
 | FILENAME
 |   ECXPRGB.pls
 |
 | DESCRIPTION
 |   PL/SQL body for package:  ECX_PURGE
 |
 | NOTES
 |   Stub version of package body for Workflow Standalone.
 |
 *=======================================================================*/

SET VERIFY OFF;
WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR EXIT FAILURE ROLLBACK;

create or replace package body ECX_PURGE as
/* $Header: ECXPRGB.pls 26.2 2004/07/05 11:57:44 vshanmug noship $*/

--
-- procedure Purge_Items
--   Delete items with end_time before argument.
-- IN:
--   itemtype - Item type to delete, or null for all itemtypes
--   itemkey - Item key to delete, or null for all itemkeys
--   enddate - Date to obsolete to
--   docommit- Do not commit if set to false
--   runtimeonly - Delete data which is associated with workflow, if set to true

procedure PURGE_ITEMS(itemType in varchar2,
                      itemKey  in varchar2,
                      endDate  in date,
                      docommit in boolean,
                      runtimeonly in boolean,
                      transactiontype in varchar2,
                      transactionsubtype in varchar2) IS
begin

  -- Null implementation for Workflow Standalone since this is referenced from
  -- Wf_Purge.Total
  null;

end PURGE_ITEMS;

end ECX_PURGE;
/
commit;
exit;
