REM dbdrv: none
/*=======================================================================+
 |        Copyright (c) 1995, 2004, Oracle. All rights reserved.         |
 +=======================================================================+
 | FILENAME
 |   ECXPRGS.pls
 |
 | DESCRIPTION
 |   PL/SQL spec for package:  ECX_PURGE
 |
 | NOTES
 |   Stub version package spec for Workflow Standalone.
 |
 *=======================================================================*/

SET VERIFY OFF;
WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR EXIT FAILURE ROLLBACK;

create or replace package ECX_PURGE as
/* $Header: ECXPRGS.pls 26.2 2004/07/05 11:57:35 vshanmug noship $*/

--
-- procedure Purge_Items
--   Delete items with end_time before argument.
-- IN:
--   itemtype - Item type to delete, or null for all itemtypes
--   itemkey - Item key to delete, or null for all itemkeys
--   enddate - Date to obsolete to
--   docommit- Do not commit if set to false
--   runtimeonly - Delete data which is associated with workflow, if set to true

procedure PURGE_ITEMS(itemType    in varchar2 default null,
                      itemKey     in varchar2 default null,
                      endDate     in date     default null,
                      docommit    in boolean  default true,
                      runtimeonly in boolean  default false,
                      transactiontype in varchar2 default null,
                      transactionsubtype in varchar2 default null);
end ECX_PURGE;
/
commit;
exit;
