REM dbdrv: sql ~PROD ~PATH ~FILE none none none package &phase=plb \
REM dbdrv: checkfile:~PROD:~PATH:~FILE

--=========================================================================--
--  Copyright (c)2001 Oracle Corporation, Redwood Shores, California, USA  --
--                          All rights reserved.                           --
--=========================================================================--
-- FILENAME                                                                --
--      WFDSEVSB.pls                                                       --
--                                                                         --
-- DESCRIPTION                                                             --
--      Evidence Store for Digital/Electronic Signatures. 		   --
--      Stub file for Oracle Workflow Standalone.
--									   --
-- PROCEDURES                                                              --
--                                                                         --
--                                                                         --
-- NOTES                                                                   --
--                                                                         --
-- HISTORY                                                                 --
--      8/11/02  M Fisher         Created.                                 --     
--      6/01/03  Vijay Shanmugam  Created stub for Workflow Standalone     --
--                                                                         --
--                                                                         --
--=========================================================================--

SET verify off
whenever sqlerror EXIT failure ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

CREATE OR REPLACE PACKAGE BODY WF_Dig_Sig_Evidence_Store AS
/* $Header: WFDSEVSB.pls 26.1 2003/01/13 04:19:51 vshanmug ship $ */

--
-- Function
--   GetMostRecentSigID
--
-- Purpose
--  Finds most recently created Sig_ID for a given object Type/ID
--  (e.g. WF_NTF 1234). 
--
-- Returns: SIG_ID for success; -1 if not successful. 
--
--

Function GetMostRecentSigID(
	SigObjType VARCHAR2,
	SigObjID   Varchar2) return number is
begin

     return -1;

exception
  when others then return -1;
end;   


--
-- Function
--   GetCertID
--
-- Purpose
--  Finds Cert_ID for a given Sig ID
--
-- Returns: Cert_ID for success; -1 if not successful. 
--
--

Function GetCertID(SigID NUMBER) return number is
begin

  return -1;

exception
  when others then return -1;
end;   

--
-- Function
--   GetSigFlavor
--
-- Purpose
--  Finds SigFlavor for a given Sig ID
--
-- Returns: SigFlavor for success; null if not successful. 
--
--

Function GetSigFlavor(SigID NUMBER) return Varchar2 is
begin

  return NULL;

exception
  when others then return null;
end;   

--
-- Function
--   GetSigPolicy
--
-- Purpose
--  Finds SigPolicy for a given Sig ID
--
-- Returns: SigPolicy for success; null if not successful. 
--
--

Function GetSigPolicy(SigID NUMBER) return Varchar2 is
begin

  return NULL;

exception
  when others then return null;
end;   


--
-- Procedure
--   GetSignature
--
-- Purpose
--  Finds Signature for a given Sig ID
--

Procedure GetSignature(SigID NUMBER, Sig out nocopy Clob) is

begin

  Sig := NULL;

exception
  when others then Sig := null;
end;   


--
-- Procedure
--   GetSigObjectInfo
--
-- Purpose
--  Finds Object Info for a given Sig ID
--

Procedure GetSigObjectInfo(SigID NUMBER, ObjType out nocopy Varchar2,
				ObjID out nocopy varchar2, ObjText out nocopy CLOB) is

begin

   ObjType := null;
   ObjID := '-1';
   ObjText := null;

exception
  when others then 
	ObjType := null;
	ObjID := '-1';
	ObjText := null;
end;   



--
-- Procedure
--   GetSigStatusInfo
--
-- Purpose
--  Finds Status Info for a given Sig ID
--

Procedure GetSigStatusInfo(SigID NUMBER, SigStatus out nocopy Number,
				CreationDate out nocopy Date,
				SignedDate out nocopy Date,
				VerifiedDate out nocopy Date,
				LastAttValDate out nocopy Date,
				ValidatedDate out nocopy Date,
				Ebuf out nocopy Varchar2,
				Estack out nocopy Varchar2) is

begin

   SigStatus := -1;
   CreationDate := null;
   SignedDate := null;
   VerifiedDate := null;
   LastAttValDate := null;
   ValidatedDate := null;
   Ebuf := null;
   Estack  := null; 

exception
  when others then 
  	SigStatus := -1;
	CreationDate := null;
	SignedDate := null;
	VerifiedDate := null;
	LastAttValDate := null;
	ValidatedDate := null;
	Ebuf := null;
 	Estack  := null;
end;   


--
-- Procedure
--   GetReqSignerInfo
--
-- Purpose
--  Finds Requested Signer Info for a given Sig ID
--

Procedure GetReqSignerInfo(SigID NUMBER, SignerType out nocopy Varchar2,
				SignerID out nocopy varchar2) is


begin

   SignerType := null;
   SignerID := '-1';

exception
  when others then 
	SignerType := null;
	SignerID := '-1';
end;   


--
-- Procedure
--   GetActualSignerInfo
--
-- Purpose
--  Finds Actual Signer Info for a given Sig ID
--

Procedure GetActualSignerInfo(SigID NUMBER, SignerType out nocopy Varchar2,
				SignerID out nocopy varchar2) is


begin

   SignerType := null;
   SignerID := '-1';

exception
  when others then 
	SignerType := null;
	SignerID := '-1';
end;   


--
-- Function
--   GetCertType
--
-- Purpose
--  Finds Cert_Type for a given Cert ID
--
-- Returns: CertType for success; null if not successful. 
--
--

Function GetCertType(CertID NUMBER) return Varchar2 is

begin

  return NULL;

exception
  when others then return null;
end;   



END WF_Dig_Sig_Evidence_Store;
/

COMMIT;
exit;


