REM dbdrv: sql ~PROD ~PATH ~FILE none none none package &phase=pls \
REM dbdrv: checkfile:~PROD:~PATH:~FILE
/*=======================================================================+
 |  Copyright (c) 2000 Oracle Corporation Redwood Shores, California, USA|
 |                            All rights reserved.                       |
 +=======================================================================+
 | FILENAME 
 |   WFEVAGPS.pls
 | DESCRIPTION
 |   PL/SQL spec for package:  WF_AGENT_GROUPS
 |
 |         PROCEDURE insert_row
 |         PROCEDURE delete_row
 |         PROCEDURE load_row
 |         FUNCTION  generate
 |         PROCEDURE receive
 *=======================================================================*/
set verify off;
whenever sqlerror exit failure rollback;
whenever oserror exit failure rollback;

create or replace package WF_AGENT_GROUPS_PKG as
/* $Header: WFEVAGPS.pls 26.6 2005/03/09 09:00:27 rtodi ship $ */
/*# 
 * This package provides the APIs that an Application Program or Business Event
 * System can call to communicate Agent Group objects to and from the database 
 * tables.
 * @rep:scope public
 * @rep:product OWF
 * @rep:displayname Workflow Agent Groups Package
 * @rep:lifecycle active
 * @rep:compatibility S
 * @rep:category BUSINESS_ENTITY WF_EVENT
 * @rep:ihelp FND/@besrepapis See the related online help
 */

-----------------------------------------------------------------------------
procedure INSERT_ROW (
  X_ROWID           in out nocopy varchar2,
  X_GROUP_GUID      in      raw,
  X_MEMBER_GUID     in      raw
);
-----------------------------------------------------------------------------
procedure UPDATE_ROW (
  X_GROUP_GUID      in      raw,
  X_MEMBER_GUID     in      raw
);
-----------------------------------------------------------------------------
procedure LOAD_ROW (
  X_GROUP_GUID      in      raw,
  X_MEMBER_GUID     in      raw
);
-----------------------------------------------------------------------------
procedure DELETE_ROW (
  X_GROUP_GUID  in  raw,
  X_MEMBER_GUID in  raw
);
-----------------------------------------------------------------------------
/*#
 * Generate Function is deprecated ,use Generate1 function.
 * Generates an XML message containing the complete information from the 
 * WF_AGENT_GROUPS table for the specified agent group member definition.
 * @param x_group_guid Agent Group GUID
 * @param x_member_guid Member Agent GUID
 * @return Agent Group XML Message
 * @rep:scope public
 * @rep:lifecycle deprecated
 * @rep:displayname Generate Agent Group Message
 * @rep:compatibility S
 * @rep:ihelp FND/@besrepapis#a_evagtgpgen See the related online help
 */
function GENERATE (
  X_GROUP_GUID  in  raw,
  X_MEMBER_GUID in  raw
) return varchar2;
-----------------------------------------------------------------------------
/*#
 * Receives an XML message containing the complete information for an agent 
 * group member definition and loads the information into the WF_AGENT_GROUPS
 * table.
 * @param x_message Agent Group XML Message
 * @rep:scope public
 * @rep:lifecycle active
 * @rep:displayname Receive Agent Group Message
 * @rep:compatibility S
 * @rep:ihelp FND/@besrepapis#a_evagtgprec See the related online help
 */
procedure RECEIVE (
  X_MESSAGE     in varchar2
);
-----------------------------------------------------------------------------
/*#
 * Generates an XML message containing the complete information from the 
 * WF_AGENT_GROUPS table for the specified agent group member definition.
 * @param x_group_guid Agent Group GUID
 * @param x_member_guid Member Agent GUID
 * @return Agent Group XML Message
 * @rep:scope public
 * @rep:lifecycle active
 * @rep:displayname Generate Agent Group Message
 * @rep:compatibility S
 * @rep:ihelp FND/@besrepapis#a_evagtgpgen See the related online help
 */
function GENERATE1(
  X_GROUP_GUID  in  varchar2,
  X_MEMBER_GUID in  varchar2
) return varchar2;
-----------------------------------------------------------------------------
end WF_AGENT_GROUPS_PKG;
/
commit;
exit;
