REM dbdrv: sql ~PROD ~PATH ~FILE none none none package &phase=pls \
REM dbdrv: checkfile:~PROD:~PATH:~FILE
/*=======================================================================+
 |  Copyright (c) 2000 Oracle Corporation Redwood Shores, California, USA|
 |                            All rights reserved.                       |
 +=======================================================================+
 | FILENAME 
 |   WFEVAGTS.pls
 | DESCRIPTION
 |   PL/SQL spec for package:  WF_AGENTS_PKG
 |
 |         PROCEDURE insert_row
 |         PROCEDURE update_row
 |         PROCEDURE delete_row
 |         PROCEDURE load_row
 |         FUNCTION  generate
 |         PROCEDURE receive
 *=======================================================================*/

SET VERIFY OFF
WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR EXIT FAILURE ROLLBACK;

create or replace package WF_AGENTS_PKG as
/* $Header: WFEVAGTS.pls 26.6 2004/05/18 06:01:18 vshanmug ship $ */
/*# 
 * This package provides the APIs that an Application Program or Business Event
 * System can call to communicate Agent objects to and from the database tables.
 * @rep:scope public
 * @rep:product OWF
 * @rep:displayname Workflow Agents Package
 * @rep:lifecycle active
 * @rep:compatibility S
 * @rep:category BUSINESS_ENTITY WF_EVENT
 * @rep:ihelp FND/@besrepapis See the related online help
 */
-----------------------------------------------------------------------------
procedure INSERT_ROW (
  X_ROWID           in out nocopy  varchar2,
  X_GUID            in      raw,
  X_NAME            in      varchar2,
  X_SYSTEM_GUID     in      raw,
  X_PROTOCOL        in      varchar2,
  X_ADDRESS         in      varchar2,
  X_QUEUE_HANDLER   in      varchar2,
  X_QUEUE_NAME      in      varchar2,
  X_DIRECTION       in      varchar2,
  X_STATUS          in      varchar2,
  X_DISPLAY_NAME    in      varchar2,
  X_DESCRIPTION     in      varchar2,
  X_TYPE            in      varchar2 default 'AGENT',
  X_JAVA_QUEUE_HANDLER in   varchar2 default null
);
-----------------------------------------------------------------------------
procedure UPDATE_ROW (
  X_GUID            in      raw,
  X_NAME            in      varchar2,
  X_SYSTEM_GUID     in      raw,
  X_PROTOCOL        in      varchar2,
  X_ADDRESS         in      varchar2,
  X_QUEUE_HANDLER   in      varchar2,
  X_QUEUE_NAME      in      varchar2,
  X_DIRECTION       in      varchar2,
  X_STATUS          in      varchar2,
  X_DISPLAY_NAME    in      varchar2,
  X_DESCRIPTION     in      varchar2,
  X_TYPE            in      varchar2 default null,
  X_JAVA_QUEUE_HANDLER in   varchar2 default null
);
-----------------------------------------------------------------------------
procedure DELETE_ROW (
  X_GUID            in      raw
);
-----------------------------------------------------------------------------
procedure LOAD_ROW (
  X_GUID            in      raw,
  X_NAME            in      varchar2,
  X_SYSTEM_GUID     in      raw,
  X_PROTOCOL        in      varchar2,
  X_ADDRESS         in      varchar2,
  X_QUEUE_HANDLER   in      varchar2,
  X_QUEUE_NAME      in      varchar2,
  X_DIRECTION       in      varchar2,
  X_STATUS          in      varchar2,
  X_DISPLAY_NAME    in      varchar2,
  X_DESCRIPTION     in      varchar2,
  X_TYPE            in      varchar2 default 'AGENT',
  X_JAVA_QUEUE_HANDLER in   varchar2 default null
);
-----------------------------------------------------------------------------
/*#
 * Generates an XML message containing the complete information from the 
 * WF_AGENTS table for the specified agent definition.
 * @param x_guid Agent GUID
 * @return Agent XML Message
 * @rep:scope public
 * @rep:lifecycle active
 * @rep:displayname Generate Agent Message
 * @rep:compatibility S
 * @rep:ihelp FND/@besrepapis#a_evagtgen See the related online help
 */
function GENERATE (
  X_GUID         in raw
) return varchar2;
-----------------------------------------------------------------------------
/*#
 * Receives an XML message containing the complete information for an agent 
 * definition and loads the information into the WF_AGENTS table.
 * @param x_message Agent XML Message
 * @rep:scope public
 * @rep:lifecycle active
 * @rep:displayname Receive Agent Message
 * @rep:compatibility S
 * @rep:ihelp FND/@besrepapis#a_evagtrec See the related online help
 */
procedure RECEIVE (
  X_MESSAGE      in varchar2
);
-----------------------------------------------------------------------------
end WF_AGENTS_PKG;
/
commit;
exit;
