REM dbdrv: sql ~PROD ~PATH ~FILE none none none package &phase=pls \
REM dbdrv: checkfile:~PROD:~PATH:~FILE
/*=======================================================================+
 |  Copyright (c) 2000 Oracle Corporation Redwood Shores, California, USA|
 |                            All rights reserved.                       |
 +=======================================================================+
 | FILENAME 
 |   WFEVGRPS.pls
 | DESCRIPTION
 |   PL/SQL spec for package:  WF_EVENT_GROUPS_PKG
 |
 |         PROCEDURE insert_row
 |         PROCEDURE delete_row
 |         PROCEDURE load_row
 |         FUNCTION  generate
 |         PROCEDURE receive
 *=======================================================================*/

SET VERIFY OFF;
WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR EXIT FAILURE ROLLBACK;

create or replace package WF_EVENT_GROUPS_PKG as
/* $Header: WFEVGRPS.pls 26.4 2004/05/18 06:01:40 vshanmug ship $ */
/*# 
 * This package provides the APIs that an Application Program or Business Event
 * System can call to communicate Event Group objects to and from the database 
 * tables.
 * @rep:scope public
 * @rep:product OWF
 * @rep:displayname Workflow Event Groups Package
 * @rep:lifecycle active
 * @rep:compatibility S
 * @rep:category BUSINESS_ENTITY WF_EVENT
 * @rep:ihelp FND/@besrepapis See the related online help
 */
-----------------------------------------------------------------------------
procedure INSERT_ROW (
  X_ROWID           in out nocopy  varchar2,
  X_GROUP_GUID      in      raw,
  X_MEMBER_GUID     in      raw
);
-----------------------------------------------------------------------------
procedure UPDATE_ROW (
  X_GROUP_GUID      in      raw,
  X_MEMBER_GUID     in      raw
);
-----------------------------------------------------------------------------
procedure LOAD_ROW (
  X_GROUP_GUID      in      raw,
  X_MEMBER_GUID     in      raw
);
-----------------------------------------------------------------------------
procedure DELETE_ROW (
  X_GROUP_GUID  in  raw,
  X_MEMBER_GUID in  raw
);
-----------------------------------------------------------------------------
/*#
 * Generates an XML message containing the complete information from the 
 * WF_EVENT_GROUPS table for the specified event group member definition.
 * @param x_group_guid Event Group GUID
 * @param x_member_guid Member Event GUID
 * @return Event Group XML Message
 * @rep:scope public
 * @rep:lifecycle active
 * @rep:displayname Generate Event Group Message
 * @rep:compatibility S
 * @rep:ihelp FND/@besrepapis#a_evgpgen See the related online help
 */
function GENERATE (
  X_GROUP_GUID  in  raw,
  X_MEMBER_GUID in  raw
) return varchar2;
-----------------------------------------------------------------------------
/*#
 * Receives an XML message containing the complete information for an event 
 * group member definition and loads the information into the WF_EVENT_GROUPS 
 * table.
 * @param x_message Event Group XML Message
 * @rep:scope public
 * @rep:lifecycle active
 * @rep:displayname Receive Event Group Message
 * @rep:compatibility S
 * @rep:ihelp FND/@besrepapis#a_evgprec See the related online help
 */
procedure RECEIVE (
  X_MESSAGE     in varchar2
);
-----------------------------------------------------------------------------
end WF_EVENT_GROUPS_PKG;
/
commit;
exit;
