REM dbdrv: sql ~PROD ~PATH ~FILE none none none package &phase=plb \
REM dbdrv: checkfile:~PROD:~PATH:~FILE 
/*=======================================================================+
 |  Copyright (c) 2000 Oracle Corporation Redwood Shores, California, USA|
 |                            All rights reserved.                       |
 +=======================================================================+
 | FILENAME
 |   WFEVPNGB.pls
 | DESCRIPTION
 |   PL/SQL body for package:  WF_EVENT_PING_PKG
 |
 *=======================================================================*/
set verify off;
whenever sqlerror exit failure rollback;
whenever oserror exit failure rollback;

create or replace package body WF_EVENT_PING_PKG as
/* $Header: WFEVPNGB.pls 26.11 2005/01/07 19:04:57 dlam ship $ */
------------------------------------------------------------------------------
/*
** launch_processes - Loops through all external agents
**
**
**
*/
procedure LAUNCH_PROCESSES (
  ITEMTYPE	in	varchar2,
  ITEMKEY	in	varchar2,
  ACTID		in	number,
  FUNCMODE	in	varchar2,
  RESULTOUT	out nocopy varchar2
) is
------------------------------------------------------------------------------

CURSOR c_external_in_agents IS
SELECT
	wfa.name AGENT,
	wfs.name SYSTEM
FROM
	wf_systems wfs,
	wf_agents wfa
WHERE
	wfa.name <> 'WF_ERROR'
and	wfa.status = 'ENABLED'
and	wfa.direction = 'IN'
and	wfa.system_guid = wfs.guid
and     upper(wfa.queue_handler) = 'WF_EVENT_QH';

l_eventname	varchar2(100);
l_eventkey	varchar2(240);
l_itemkey	varchar2(100);
l_event_t	wf_event_t;
l_msg		varchar2(32000);
l_clob		clob;

begin

if (funcmode = 'RUN') then

  l_eventname := wf_engine.GetActivityAttrText(
                        itemtype => itemtype,
                        itemkey  => itemkey,
                        actid    => actid,
                        aname    => 'EVNTNAME');

  for x in c_external_in_agents loop
    --
    -- For every agent launch detail process
    --
    l_eventkey := x.agent||'@'||x.system||'@'||itemkey;
    l_itemkey := l_eventkey;

    wf_engine.CreateProcess(
			itemtype => itemtype,
			itemkey  => l_itemkey,
			process  => 'WFDTLPNG');

    wf_engine.SetItemAttrText(
			itemtype => itemtype,
			itemkey  => l_itemkey,
			aname    => 'EVNTNAME',
			avalue   => l_eventname);

    wf_engine.SetItemAttrText(    
                        itemtype => itemtype,
                        itemkey  => l_itemkey,
                        aname    => 'EVNTKEY',
                        avalue   => l_eventkey);

    wf_engine.SetItemAttrText(
                        itemtype => itemtype,
                        itemkey  => l_itemkey,
                        aname    => 'TOAGENT',
                        avalue   => x.agent||'@'||x.system); 

    -- Initialise the wf_event_t
    wf_event_t.initialize(l_event_t);
    l_event_t.setcorrelationid(l_itemkey);
    l_msg := '<PING>Test Ping</PING>';
    dbms_lob.createtemporary(l_clob, FALSE, DBMS_LOB.CALL); 
    dbms_lob.write(l_clob, length(l_msg), 1 , l_msg); 
    l_event_t.SetEventData(l_clob);

    wf_engine.SetItemAttrEvent(
			itemtype => itemtype,
                        itemkey  => l_itemkey,
			name	 => 'EVNTMSG',
			event   => l_event_t); 

    wf_engine.SetItemParent(
			itemtype => itemtype,
			itemkey  => l_itemkey,
			parent_itemtype => itemtype,
			parent_itemkey  => itemkey,
			parent_context  => null);

    wf_engine.StartProcess(
			itemtype => itemtype,
			itemkey  => l_itemkey);

  end loop;
	
  resultout := wf_engine.eng_completed||':'||wf_engine.eng_null;
 
  return;

elsif (funcmode = 'CANCEL') then

  null;

end if;

exception
  when others then
  WF_CORE.CONTEXT('WF_EVENT_PING_PKG', 'LAUNCH_PROCESSES', ITEMTYPE, ITEMKEY, to_char(ACTID), FUNCMODE);
  raise;
end LAUNCH_PROCESSES;
------------------------------------------------------------------------------
function ACKNOWLEDGE (
 P_SUBSCRIPTION_GUID	in	raw,
 P_EVENT		in out nocopy wf_event_t
) return varchar2 is
------------------------------------------------------------------------------
l_fromagent	wf_agent_t;
l_result	varchar2(100);
l_returnagent	varchar2(100);

CURSOR c_return_agent (p_name VARCHAR2) IS
SELECT  wfa.name AGENT
FROM
        wf_systems wfs,
        wf_agents wfa,
        wf_resources res
WHERE
        res.name = 'WF_SYSTEM_GUID'
and     res.language = userenv('LANG')
and     wfa.system_guid = res.text
and     wfs.name = p_name
and     wfa.name <> 'WF_ERROR'
and     wfa.status = 'ENABLED'
and     wfa.direction = 'IN'
and     upper(wfa.queue_handler) = 'WF_EVENT_QH';

begin

l_fromagent := wf_agent_t (NULL, NULL);

/*
** Get the Return To Agent
*/
  open c_return_agent (p_event.from_agent.system);
  fetch c_return_agent into l_returnagent;
  close c_return_agent;

/*
** Null out From Agent, repackage up the event and use wf_event.send
**
*/
  if (wf_log_pkg.level_procedure >= fnd_log.g_current_runtime_level) then
     wf_log_pkg.string(wf_log_pkg.level_procedure, 
                      'wf.plsqlWF_EVENT_PING_PKG.ACKNOWLEDGE.Begin',
                      ' Started');
  end if;

  p_event.to_agent.name := l_returnagent;
  p_event.to_agent.system := p_event.from_agent.system;

  p_event.SetFromAgent(l_FromAgent);

  if (wf_log_pkg.level_statement >= fnd_log.g_current_runtime_level) then
     wf_log_pkg.string(wf_log_pkg.level_statement, 
                      'wf.plsqlWF_EVENT_PING_PKG.ACKNOWLEDGE.ToAgent',
                      'To Agent:'||p_event.to_agent.name);
     wf_log_pkg.string(wf_log_pkg.level_statement, 
                      'wf.plsqlWF_EVENT_PING_PKG.ACKNOWLEDGE.ToSystem',
                      'To System:'||p_event.to_agent.system);
     wf_log_pkg.string(wf_log_pkg.level_statement, 
                      'wf.plsqlWF_EVENT_PING_PKG.ACKNOWLEDGE.FromAgent',
                      'From Agent:'||p_event.from_agent.name);
     wf_log_pkg.string(wf_log_pkg.level_statement, 
                      'wf.plsqlWF_EVENT_PING_PKG.ACKNOWLEDGE.FromSystem',
                      'From System:'||p_event.from_agent.system);
  end if;
  
  p_event.SetEventName('oracle.apps.wf.event.test.ack');

  if (wf_log_pkg.level_statement >= fnd_log.g_current_runtime_level) then
     wf_log_pkg.string(wf_log_pkg.level_statement, 
                      'wf.plsqlWF_EVENT_PING_PKG.ACKNOWLEDGE.Send',
                      'Sending Event');
  end if;
  
  wf_event.send(
	p_event => p_event);
	
  if (wf_log_pkg.level_statement >= fnd_log.g_current_runtime_level) then
     wf_log_pkg.string(wf_log_pkg.level_statement,
                      'wf.plsqlWF_EVENT_PING_PKG.ACKNOWLEDGE.Sent',
                      ' Sent');
  end if;
  
  l_result := wf_rule.default_rule(p_subscription_guid, p_event);

  return(l_result);

exception
  when others then
  WF_CORE.CONTEXT('WF_EVENT_PING_PKG','ACKNOWLEDGE',p_event.event_name,p_event.event_key, p_event.correlation_id);
  wf_event.setErrorInfo(p_event,'ERROR');
  return('ERROR');
end; 

end WF_EVENT_PING_PKG;
/
-- show errors package body WF_EVENT_PING_PKG
commit;
exit;
