REM dbdrv: sql ~PROD ~PATH ~FILE none none none package &phase=pls \
REM dbdrv: checkfile:~PROD:~PATH:~FILE 
/*=======================================================================+
 |  Copyright (c) 2000 Oracle Corporation Redwood Shores, California, USA|
 |                            All rights reserved.                       |
 +=======================================================================+
 | FILENAME
 |   WFEVPNGS.pls
 | DESCRIPTION
 |   PL/SQL spec for package:  WF_EVENT_PING_PKG
 |
 *=======================================================================*/
set verify off;
WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR EXIT FAILURE ROLLBACK;
/*  
**   package WF_EVENT_PING_PKG
**
**	PROCEDURE launch_processes
**	FUNCTION  acknowledge
**
*/
create or replace package WF_EVENT_PING_PKG as
/* $Header: WFEVPNGS.pls 26.4 2005/01/07 19:04:39 dlam ship $ */
------------------------------------------------------------------------------
/*
** launch_processes - Loops through all external agents
**			creates  1 child process/external agent to ping
**			
**
**
*/
procedure LAUNCH_PROCESSES (
  ITEMTYPE	in	varchar2,
  ITEMKEY	in	varchar2,
  ACTID		in	number,
  FUNCMODE	in	varchar2,
  RESULTOUT	out nocopy varchar2
);
------------------------------------------------------------------------------
/*
** acknowledge - Repackages payload to send event back to From Agent and to be
**		 of event type oracle.apps.wf.event.agent.ack
**
**
**
*/
function ACKNOWLEDGE (
 P_SUBSCRIPTION_GUID	in	raw,
 P_EVENT		in out nocopy wf_event_t
) return varchar2;
------------------------------------------------------------------------------
end WF_EVENT_PING_PKG;
/
-- show errors package WF_EVENT_PING_PKG
commit;
exit;
