REM dbdrv: sql ~PROD ~PATH ~FILE none none none package &phase=pls \
REM dbdrv: checkfile:~PROD:~PATH:~FILE
/*=======================================================================+
 |  Copyright (c) 2000 Oracle Corporation Redwood Shores, California, USA|
 |                            All rights reserved.                       |
 +=======================================================================+
 | FILENAME 
 |   WFEVSUBS.pls
 | DESCRIPTION
 |   PL/SQL spec for package:  WF_EVENT_SUBSCRIPTIONS_PKG
 |
 |         PROCEDURE insert_row
 |         PROCEDURE update_row
 |         PROCEDURE load_row
 |         PROCEDURE delete_row
 |         PROCEDURE delete_set
 |         FUNCTION  generate
 |         PROCEDURE receive
 | 09.27.2002   varrajar Bug 2558446. Preserve Customization of events
 |              Also sets the licensed_flag based on OWNER_TAG 
 | 12-03-2002   kma      Add NOCOPY hint to OUT or IN OUT parameter.
 | 11-16-2003   vbhatia  Add ACTION_CODE, ON_ERROR_CODE, and JAVA_RULE_FUNC
 |                       to procedures.
 | 12-02-2003   vbhatia  Add MAP_CODE, STANDARD_CODE, and STANDARD_TYPE
 |                       to procedures.
 *=======================================================================*/

SET VERIFY OFF
WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR EXIT FAILURE ROLLBACK;

create or replace package WF_EVENT_SUBSCRIPTIONS_PKG as
/* $Header: WFEVSUBS.pls 26.11 2004/05/21 06:22:10 vshanmug ship $ */
/*# 
 * This package provides the APIs that an Application Program or Business Event
 * System can call to communicate Event Subscription objects to and from the 
 * database tables.
 * @rep:scope public
 * @rep:product OWF
 * @rep:displayname Workflow Event Subscriptions Package
 * @rep:lifecycle active
 * @rep:compatibility S
 * @rep:category BUSINESS_ENTITY WF_EVENT
 * @rep:ihelp FND/@besrepapis See the related online help
 */

-----------------------------------------------------------------------------
procedure INSERT_ROW (
  X_ROWID              in out nocopy varchar2,
  X_GUID               in     raw,
  X_SYSTEM_GUID        in     raw,
  X_SOURCE_TYPE        in     varchar2,
  X_SOURCE_AGENT_GUID  in     raw,
  X_EVENT_FILTER_GUID  in     raw,
  X_PHASE              in     number,
  X_STATUS             in     varchar2,
  X_RULE_DATA          in     varchar2,
  X_OUT_AGENT_GUID     in     raw,
  X_TO_AGENT_GUID      in     raw,
  X_PRIORITY           in     number,
  X_RULE_FUNCTION      in     varchar2,
  X_WF_PROCESS_TYPE    in     varchar2,
  X_WF_PROCESS_NAME    in     varchar2,
  X_PARAMETERS         in     varchar2,
  X_OWNER_NAME         in     varchar2,
  X_OWNER_TAG          in     varchar2,
  X_CUSTOMIZATION_LEVEL in     varchar2,
  X_LICENSED_FLAG       in     varchar2 default 'N',
  X_DESCRIPTION        in     varchar2,
  X_EXPRESSION         in     varchar2 default null,
  X_ACTION_CODE        in     varchar2 default null,
  X_ON_ERROR_CODE      in     varchar2 default 'SKIP',
  X_JAVA_RULE_FUNC     in     varchar2 default null,
  X_MAP_CODE           in     varchar2 default null,
  X_STANDARD_CODE      in     varchar2 default null,
  X_STANDARD_TYPE      in     varchar2 default null
);
-----------------------------------------------------------------------------
procedure UPDATE_ROW (
  X_GUID               in     raw,
  X_SYSTEM_GUID        in     raw,
  X_SOURCE_TYPE        in     varchar2,
  X_SOURCE_AGENT_GUID  in     raw,
  X_EVENT_FILTER_GUID  in     raw,
  X_PHASE              in     number,
  X_STATUS             in     varchar2,
  X_RULE_DATA          in     varchar2,
  X_OUT_AGENT_GUID     in     raw,
  X_TO_AGENT_GUID      in     raw,
  X_PRIORITY           in     number,
  X_RULE_FUNCTION      in     varchar2,
  X_WF_PROCESS_TYPE    in     varchar2,
  X_WF_PROCESS_NAME    in     varchar2,
  X_PARAMETERS         in     varchar2,
  X_OWNER_NAME         in     varchar2,
  X_OWNER_TAG          in     varchar2,
  X_CUSTOMIZATION_LEVEL in     varchar2,
  X_LICENSED_FLAG       in     varchar2 default 'N',
  X_DESCRIPTION        in     varchar2,
  X_EXPRESSION         in     varchar2 default null,
  X_ACTION_CODE        in     varchar2 default null,
  X_ON_ERROR_CODE      in     varchar2 default 'SKIP',
  X_JAVA_RULE_FUNC     in     varchar2 default null,
  X_MAP_CODE           in     varchar2 default null,
  X_STANDARD_CODE      in     varchar2 default null,
  X_STANDARD_TYPE      in     varchar2 default null
);
-----------------------------------------------------------------------------
procedure LOAD_ROW (
  X_GUID               in     raw,
  X_SYSTEM_GUID        in     raw,
  X_SOURCE_TYPE        in     varchar2,
  X_SOURCE_AGENT_GUID  in     raw,
  X_EVENT_FILTER_GUID  in     raw,
  X_PHASE              in     number,
  X_STATUS             in     varchar2,
  X_RULE_DATA          in     varchar2,
  X_OUT_AGENT_GUID     in     raw,
  X_TO_AGENT_GUID      in     raw,
  X_PRIORITY           in     number,
  X_RULE_FUNCTION      in     varchar2,
  X_WF_PROCESS_TYPE    in     varchar2,
  X_WF_PROCESS_NAME    in     varchar2,
  X_PARAMETERS         in     varchar2,
  X_OWNER_NAME         in     varchar2,
  X_OWNER_TAG          in     varchar2,
  X_CUSTOMIZATION_LEVEL in     varchar2,
  X_LICENSED_FLAG       in     varchar2 default 'N',
  X_DESCRIPTION        in     varchar2,
  X_EXPRESSION         in     varchar2 default null,
  X_ACTION_CODE        in     varchar2 default null,
  X_ON_ERROR_CODE      in     varchar2 default 'SKIP',
  X_JAVA_RULE_FUNC     in     varchar2 default null,
  X_MAP_CODE           in     varchar2 default null,
  X_STANDARD_CODE      in     varchar2 default null,
  X_STANDARD_TYPE      in     varchar2 default null
);
-----------------------------------------------------------------------------
procedure DELETE_ROW (
  X_GUID              in     raw
);
-----------------------------------------------------------------------------
procedure DELETE_SET (
  X_SYSTEM_GUID        in     raw       default null,
  X_SOURCE_TYPE        in     varchar2  default null,
  X_SOURCE_AGENT_GUID  in     raw       default null,
  X_EVENT_FILTER_GUID  in     raw       default null,
  X_PHASE              in     number    default null,
  X_STATUS             in     varchar2  default null,
  X_RULE_DATA          in     varchar2  default null,
  X_OUT_AGENT_GUID     in     raw       default null,
  X_TO_AGENT_GUID      in     raw       default null,
  X_PRIORITY           in     number    default null,
  X_RULE_FUNCTION      in     varchar2  default null,
  X_WF_PROCESS_TYPE    in     varchar2  default null,
  X_WF_PROCESS_NAME    in     varchar2  default null,
  X_PARAMETERS         in     varchar2  default null,
  X_OWNER_NAME         in     varchar2  default null,
  X_OWNER_TAG          in     varchar2  default null,
  X_DESCRIPTION        in     varchar2  default null,
  X_EXPRESSION         in     varchar2  default null,
  X_ACTION_CODE        in     varchar2 default null,
  X_ON_ERROR_CODE      in     varchar2 default 'SKIP',
  X_JAVA_RULE_FUNC     in     varchar2 default null,
  X_MAP_CODE           in     varchar2 default null,
  X_STANDARD_CODE      in     varchar2 default null,
  X_STANDARD_TYPE      in     varchar2 default null
);
-----------------------------------------------------------------------------
/*#
 * Generates an XML message containing the complete information from the 
 * WF_EVENT_SUBSCRIPTIONS table for the specified event subscription definition.
 * @param x_guid Event Subscription GUID
 * @return Event Subscription XML Message
 * @rep:scope public
 * @rep:lifecycle active
 * @rep:displayname Generate Event Subscriptions Message
 * @rep:compatibility S
 * @rep:ihelp FND/@besrepapis#a_evsubgen See the related online help
 */
function GENERATE (
  X_GUID         in raw
) return varchar2;
-----------------------------------------------------------------------------
/*#
 * Receives an XML message containing the complete information for an event 
 * subscription definition and loads the information into the 
 * WF_EVENT_SUBSCRIPTIONS table.
 * @param x_message Event Subscription XML Message
 * @rep:scope public
 * @rep:lifecycle active
 * @rep:displayname Receive Event Subscriptions Message
 * @rep:compatibility S
 * @rep:ihelp FND/@besrepapis#a_evsubrec See the related online help
 */
procedure RECEIVE (
  X_MESSAGE      in varchar2
);
-----------------------------------------------------------------------------
end WF_EVENT_SUBSCRIPTIONS_PKG;
/
commit;
exit;
