REM dbdrv:none
/*=======================================================================+
 |  Copyright (c) 2000 Oracle Corporation Redwood Shores, California, USA|
 |                            All rights reserved.                       |
 +=======================================================================+
 | FILENAME 
 |   WFEVSYSS.pls
 | DESCRIPTION
 |   PL/SQL spec for package:  WF_SYSTEMS_PKG
 |
 |         PROCEDURE insert_row
 |         PROCEDURE update_row
 |         PROCEDURE delete_row
 |         PROCEDURE load_row
 |         FUNCTION  generate
 |         PROCEDURE receive
 *=======================================================================*/

set verify off
whenever sqlerror exit failure rollback;
whenever oserror exit failure rollback;
create or replace package WF_SYSTEMS_PKG as
/* $Header: WFEVSYSS.pls 26.3 2004/06/02 12:43:03 vshanmug ship $ */
/*# 
 * This package provides the APIs that an Application Program or Business Event
 * System can call to communicate System objects to and from the database 
 * tables.
 * @rep:scope public
 * @rep:product OWF
 * @rep:displayname Workflow Systems Package
 * @rep:lifecycle active
 * @rep:compatibility S
 * @rep:category BUSINESS_ENTITY WF_EVENT
 * @rep:ihelp FND/@besrepapis See the related online help
 */

-----------------------------------------------------------------------------
procedure INSERT_ROW (
  X_ROWID        in out nocopy varchar2,
  X_GUID         in     raw,
  X_NAME         in     varchar2,
  X_MASTER_GUID  in     raw,
  X_DISPLAY_NAME in     varchar2,
  X_DESCRIPTION  in     varchar2
);
-----------------------------------------------------------------------------
procedure UPDATE_ROW (
  X_GUID         in raw,
  X_NAME         in varchar2,
  X_MASTER_GUID  in raw,
  X_DISPLAY_NAME in varchar2,
  X_DESCRIPTION  in varchar2
);
-----------------------------------------------------------------------------
procedure DELETE_ROW (
  X_GUID         in raw
);
-----------------------------------------------------------------------------
procedure LOAD_ROW (
  X_GUID         in raw,
  X_NAME         in varchar2,
  X_MASTER_GUID  in raw,
  X_DISPLAY_NAME in varchar2,
  X_DESCRIPTION  in varchar2
);
-----------------------------------------------------------------------------
/*#
 * Generates an XML message containing the complete information from the 
 * WF_SYSTEMS table for the specified system definition.
 * @param x_guid System GUID
 * @return System XML Message
 * @rep:scope public
 * @rep:lifecycle active
 * @rep:displayname Generate System Message
 * @rep:compatibility S
 * @rep:ihelp FND/@besrepapis#a_evsysgen See the related online help
 */
function GENERATE (
  X_GUID         in raw
) return varchar2;
-----------------------------------------------------------------------------
/*#
 * Receives an XML message containing the complete information for an agent 
 * definition and loads the information into the WF_AGENTS table.
 * @param x_message System XML Message
 * @rep:scope public
 * @rep:lifecycle active
 * @rep:displayname Receive System Message
 * @rep:compatibility S
 * @rep:ihelp FND/@besrepapis#a_evsysrec See the related online help
 */
procedure RECEIVE (
  X_MESSAGE      in varchar2
);
-----------------------------------------------------------------------------
end WF_SYSTEMS_PKG;
/
commit;
exit;



