REM dbdrv: sql ~PROD ~PATH ~FILE none none none package &phase=pls \
REM dbdrv: checkfile:~PROD:~PATH:~FILE

--=========================================================================--
--  Copyright (c)2001 Oracle Corporation, Redwood Shores, California, USA  --
--                          All rights reserved.                           --
--=========================================================================--
-- FILENAME                                                                --
--      WFHAMIGS.pls                                                       --
--                                                                         --
-- DESCRIPTION                                                             --
--                                                                         --
-- PROCEDURES                                                              --
--                                                                         --
--      FixSubscriptions						   --
--      RESET_HA_FLAGS							   --
--      SET_HA_FLAG							   --
--      EXPORT_ITEMS                                                       --
--                                                                         --
-- FUNCTIONS                                                               --
--                                                                         --
--      GET_CACHED_HA_MAINT_MODE                                           --
--      GET_HA_MAINT_MODE                                                  --
--                                                                         --
-- NOTES                                                                   --
--                                                                         --
-- HISTORY                                                                 --
--      11/19/01  M Fisher  created.                                       --
--                                                                         --
--                                                                         --
--=========================================================================--

SET verify off
whenever sqlerror EXIT failure ROLLBACK;
WHENEVER OSERROR EXIT FAILURE ROLLBACK;

CREATE OR REPLACE PACKAGE WF_HA_MIGRATION AS
/* $Header: WFHAMIGS.pls 26.5 2002/11/11 05:22:39 rosthoma ship $ */


--
-- Procedure
--   RESET_HA_FLAGS
--
-- Purpose
--   Resets the Migration Flags on WF_ITEMS.  Performs Commit.
--
-- Arguments: None
--
Procedure RESET_HA_FLAGS(errbuf out varchar2, retcode out number);

--
-- Procedure
--   SET_HA_FLAG
--
-- Purpose
--   Sets the Migration Flag on WF_ITEMS for a particular item.
--
-- Arguments:
--   Item_Type, Item_Key
--
Procedure SET_HA_FLAG(x_item_type in varchar2, x_item_key in varchar2);


--
-- Function
--   GET_HA_MAINT_MODE
--
-- Purpose
--   Returns the Current High Availability Maintenance Mode.
--
-- Arguments: None
--
FUNCTION GET_HA_MAINT_MODE return varchar2;


--
-- Function
--   GET_CACHED_HA_MAINT_MODE
--
-- Purpose
--   Returns the Cacched High Availability Maintenance Mode if available,
--   other wise the current one.
--
-- Arguments: None
--
FUNCTION GET_CACHED_HA_MAINT_MODE return varchar2;


--
-- Procedure
--   Export Items
--
-- Purpose
--   Shipped updated items from WF_ITEMS and associated tables to the
--   maintanence system...continues until no more txns being processed on old 
--   system, and no more backlog to process.
--
-- Arguments: None
--
PROCEDURE EXPORT_ITEMS(errbuf out varchar2, retcode out number);

--
-- Procedure
--   FixSubscriptions
--
-- Purpose
--   Shipped updated items from WF_ITEMS and associated tables to the
--   maintanence system...continues until no more txns being processed on old
--   system, and no more backlog to process.
--
-- Arguments: 
--	WF_Schema in varchar2 - Schema for FND.
--	Clone_DBLink in varchar2 - DBLink for cloned DB.
--
PROCEDURE FixSubscriptions(WF_Schema in varchar2 default 'APPLSYS', Clone_DBLink in varchar2);
  
END WF_HA_MIGRATION;
/
COMMIT;
exit;


