/*=======================================================================+
 |  Copyright (c) 2000 Oracle Corporation Redwood Shores, California, USA|
 |                            All rights reserved.                       |
 +=======================================================================+
 | FILENAME
 |   WFLDAPS.pls
 | DESCRIPTION
 |   PL/SQL spec for package:  WF_LDAP
 |
 | 04.18.2003 varrajar Bug: 2915451: changed get_name_attr be a private routine
 *=======================================================================*/

REM dbdrv: sql ~PROD ~PATH ~FILE none none none package &phase=pls \
REM dbdrv: checkfile:~PROD:~PATH:~FILE

set verify off;
whenever sqlerror exit failure rollback;
WHENEVER OSERROR EXIT FAILURE ROLLBACK;

/*
**   package WF_LDAP
**
**    FUNCTION   synch_changes
**    FUNCTION   synch_all
**    PROCEDURE  synch_concurrent
**    PROCEDURE  update_ldap
**    PROCEDURE  schedule_changes
*/
create or replace package WF_LDAP as
/* $Header: WFLDAPS.pls 26.11 2004/05/18 08:16:13 rosthoma ship $ */
/*#
 * This public interface provides APIs to synchronize 
 * your Oracle Workflow directory service with 
 * Oracle Internet Directory (OID). 
 * @rep:scope public
 * @rep:product OWF
 * @rep:displayname Workflow Lightweight Directory Access Protocol
 * @rep:lifecycle active
 * @rep:compatibility S
 * @rep:category BUSINESS_ENTITY WF_USER
 * @rep:ihelp FND/@wfldap See the related online help
 */
------------------------------------------------------------------------------
/*
** synch_concurrent - cover for synch_changes and synch_all used
**                    by the Concurrent Manager.
*/
PROCEDURE synch_concurrent(errbuf  out nocopy varchar2,
                           retcode out nocopy varchar2,
                           p_mode  in  varchar2 default 'CHANGES');
------------------------------------------------------------------------------
/*
** synch_changes - Determines "recent" user changes to an LDAP directory,
**                 stores the user attribute information in an attribute cache,
**                 and raises a business event to alert interested parties.  
**                 One event is raised for each changed user.
*/
/*#
 * This API identifies LDAP user changes in OID (including
 * creation, modification, and deletion) from the LDAP change
 * logs and updates wf_local_users table with the changed user
 * information
 * @return Success or Failure
 * @rep:scope public
 * @rep:lifecycle active
 * @rep:displayname Synchronize Changes
 * @rep:businessevent oracle.apps.wf.public.user.change
 * @rep:ihelp FND/@wfldap#a_ldsych See the related online help
 */
FUNCTION synch_changes return boolean;
------------------------------------------------------------------------------
/*
** synch_all - Similar to synch_changes, but stores attribute info for 
**             ALL of the users in an LDAP directory.  Useful for installs
**             and recovery.
*/
/*#
 * This API helps synchronize your Oracle Workflow directory 
 * service with OID . It retrieves all the existing user 
 * information from OID, based on the LDAP directory 
 * information specified in the global Workflow preferences, 
 * and loads the user information into the WF_LOCAL_USERS table. 
 * @return Success or Failure
 * @rep:scope public
 * @rep:lifecycle active
 * @rep:businessevent oracle.apps.wf.public.user.change
 * @rep:displayname Synchronize All Changes
 * @rep:ihelp FND/@wfldap#a_ldsyal See the related online help
 */
FUNCTION synch_all return boolean;
------------------------------------------------------------------------------
/*
** update_ldap - Update LDAP directory with specified entity changes
*/
PROCEDURE update_ldap(p_entity_type      in varchar2,
                      p_entity_key_value in varchar2,
                      p_change_source    in varchar2,
                      p_change_type      in varchar2,
                      p_user_base        in varchar2);
------------------------------------------------------------------------------
/*
** schedule_changes - Wrapper for synch_changes, repeats at the given 
**                    time interval.  Useful for standalone (no conc mgr)
*/
/*#
 * This procedure submits a database job using the
 * DBMS_JOB utility to synchronize any change in user 
 * information in the OID to the wf_local_users table 
 * repeatedly at an interval that you specify. The default interval
 * is ten minutes
 * @param l_day Day 
 * @param l_hour Hours
 * @param l_minute Minutes 
 * @rep:scope public
 * @rep:lifecycle active
 * @rep:displayname Schedule Synchronize Changes
 * @rep:ihelp FND/@wfldap#a_ldscch See the related online help
 */
PROCEDURE schedule_changes(l_day    in pls_integer default 0,
                           l_hour   in pls_integer default 0,
                           l_minute in pls_integer default 10);
------------------------------------------------------------------------------

end WF_LDAP;
/
commit;
exit;
