REM dbdrv: sql ~PROD ~PATH ~FILE none none none package &phase=pls \
REM dbdrv: checkfile:~PROD:~PATH:~FILE
/*=======================================================================+
 |  Copyright (c) 2000 Oracle Corporation Redwood Shores, California, USA|
 |                            All rights reserved.                       |
 +=======================================================================+
 | FILENAME
 |   WFLOGPKS.pls
 |
 | DESCRIPTION
 |   PL/SQL spec for package:  WF_LOG_PKG
 |
 | NOTES
 |   Common Package Spec for WF_LOG_PKG shared by both APPS and Standalone
 |   though the implementation is different between APPS and Standalone
 |
 | APIs
 |   procedure Init
 |   procedure String
 |   function  Test
 *=======================================================================*/

set verify off
whenever sqlerror exit failure rollback;
whenever oserror exit failure rollback;

create or replace package WF_LOG_PKG as
/* $Header: WFLOGPKS.pls 26.3 2004/06/29 20:56:33 yohuang ship $ */
------------------------------------------------------------------------------
/*
**      wf_debug_flag - Global Variable to hold whether debug on or off
**      ** May not be used when moved to FND Logging **
*/

WF_DEBUG_FLAG  	 BOOLEAN DEFAULT FALSE;

/*
**	Level Global Variables - enables filtering of messages
*/
LEVEL_UNEXPECTED CONSTANT NUMBER  := 6;
LEVEL_ERROR      CONSTANT NUMBER  := 5;
LEVEL_EXCEPTION  CONSTANT NUMBER  := 4;
LEVEL_EVENT      CONSTANT NUMBER  := 3;
LEVEL_PROCEDURE  CONSTANT NUMBER  := 2;
LEVEL_STATEMENT  CONSTANT NUMBER  := 1;

------------------------------------------------------------------------------
/*
** Init - Initialise the Logging global variables to do standalone testing.
**        This will do the same work as wf_log_pkg.wf_debug_flag.
** Change LOG_ENABLED to binary integer because JDBC doesn't support PL/SQL boolean.
** 0 means false, 1 means true
*/
procedure Init (
   LOG_ENABLED  in binary_integer default 0,
   LOG_FILENAME in varchar2 default NULL,
   LOG_LEVEL    in number   default 5,
   LOG_MODULE   in varchar2 default '%',
   FND_USER_ID  in number   default 0,
   FND_RESP_ID  in number   default -1,
   FND_APPL_ID  in number   default -1
);

------------------------------------------------------------------------------
/*
** SET_LEVEL - Change the PL/SQL Log Level
*/
procedure SET_LEVEL (
   LOG_LEVEL    in number   default 5
);
------------------------------------------------------------------------------
/*
** String - Procedure to output to screen log messages, only works if called
**	    from SQL*Plus and debug global variable set to TRUE
*/
procedure String (
  LOG_LEVEL	in number,
  MODULE	in varchar2,
  MESSAGE	in varchar2
);
------------------------------------------------------------------------------
/*
** Test - Function to verify if the logging is enabled for the given
**             Log Level
*/
function Test (
   LOG_LEVEL in number,
   MODULE    in varchar2
)
return boolean;

end WF_LOG_PKG;
/
commit;
exit;
