REM dbdrv: sql ~PROD ~PATH ~FILE none none none sqlplus_single &phase=dat \
REM dbdrv: checkfile:~PROD:~PATH:~FILE
REM *=======================================================================+
REM |  Copyright (c) 1995 Oracle Corporation Redwood Shores, California, USA|
REM |                            All rights reserved.                       |
REM +=======================================================================+
REM | FILENAME
REM |   afdmsed.sql
REM | DESCRIPTION
REM |   Seed Data for Document Management Integration Definition Dictionary
REM |   None of this data is translated so we can use simple insert statements
REM *=======================================================================*

SET VERIFY OFF
WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR EXIT FAILURE ROLLBACK;

set escape '\'
set array 1
set scan off

REM $Header: afdmsed.sql 26.6 2002/11/11 02:57:45 rosthoma ship $


REM
REM FND_DM_PRODUCTS
REM

prompt Delete the Internet Documents and OpenText Entries

delete from fnd_dm_products where product_id in (1, 10);


REM Livelink V8
insert into fnd_dm_products 
( 
product_id,
product_name,
vendor_name,
version
)
select
 10, 
 'LiveLink Internet', 
 'OpenText',
 '8.0.X'
from dual
where not exists
(select 'x'
 from fnd_dm_products
 where product_id = 10);

insert into fnd_dm_products 
( 
product_id,
product_name,
vendor_name,
version
)
select
 1, 
 'Internet Documents', 
 'Oracle',
 '2.0'
from dual
where not exists
(select 'x'
 from fnd_dm_products
 where product_id = 1);



REM FND_DM_FUNCTIONS

prompt Delete and recreate all the entries

delete from fnd_dm_functions;

delete from fnd_dm_function_parameters;

prompt Seeding Search

insert into fnd_dm_functions (
 function_id		     ,
 function_name		     ,
 sequence                    ,
 new_document_function       ,
 existing_document_function  ,
 resource_name               ,
 icon_name                   )     
select 
 10, 
 'get_search_document_url',
 10,
 'Y',
 'N',
 'WFDM_SEARCH',
 'search.gif'
from dual
where not exists 
(select 'x'
 from  fnd_dm_functions 
 where function_id = 10);

insert into fnd_dm_function_parameters ( 
 parameter_id	,
 parameter_name	,
 function_id)
select 10, 
 'CALLBACK',
 10
from dual
where not exists
(select 'x'
 from fnd_dm_function_parameters
 where parameter_id = 10);

insert into fnd_dm_function_parameters ( 
 parameter_id	,
 parameter_name	,
 function_id)
select 12,
 'USERNAME',
 10
from dual
where not exists
(select 'x'
 from fnd_dm_function_parameters
 where parameter_id = 12);

insert into fnd_dm_function_parameters ( 
 parameter_id	,
 parameter_name	,
 function_id)
select 14,
 'TICKET',
 10
from dual
where not exists
(select 'x'
 from fnd_dm_function_parameters
 where parameter_id = 14);

prompt Seeding Add

insert into fnd_dm_functions (
 function_id		     ,
 function_name		     ,
 sequence                    ,
 new_document_function       ,
 existing_document_function  ,
 resource_name               ,
 icon_name                   )     
select 
 20, 
 'get_create_document_url',
 20,
 'Y',
 'N',
 'WFDM_CREATE',
 'adddoc.gif'
from dual
where not exists 
(select 'x'
 from  fnd_dm_functions 
 where function_id = 20);

insert into fnd_dm_function_parameters ( 
 parameter_id	,
 parameter_name	,
 function_id)
select 20, 
 'CALLBACK',
 20
from dual
where not exists
(select 'x'
 from fnd_dm_function_parameters
 where parameter_id = 20);

insert into fnd_dm_function_parameters ( 
 parameter_id	,
 parameter_name	,
 function_id)
select 22,
 'USERNAME',
 20
from dual
where not exists
(select 'x'
 from fnd_dm_function_parameters
 where parameter_id = 22);

insert into fnd_dm_function_parameters ( 
 parameter_id	,
 parameter_name	,
 function_id)
select 24,
 'TICKET',
 20
from dual
where not exists
(select 'x'
 from fnd_dm_function_parameters
 where parameter_id = 24);


prompt Seeding Browse

insert into fnd_dm_functions (
 function_id		     ,
 function_name		     ,
 sequence                    ,
 new_document_function       ,
 existing_document_function  ,
 resource_name               ,
 icon_name                   )     
select 
 25, 
 'get_browse_document_url',
 25,
 'Y',
 'N',
 'WFDM_BROWSE',
 'affind.gif'
from dual
where not exists 
(select 'x'
 from  fnd_dm_functions 
 where function_id = 25);

insert into fnd_dm_function_parameters ( 
 parameter_id	,
 parameter_name	,
 function_id)
select 25, 
 'CALLBACK',
 25
from dual
where not exists
(select 'x'
 from fnd_dm_function_parameters
 where parameter_id = 25);

insert into fnd_dm_function_parameters ( 
 parameter_id	,
 parameter_name	,
 function_id)
select 26,
 'USERNAME',
 25
from dual
where not exists
(select 'x'
 from fnd_dm_function_parameters
 where parameter_id = 26);

insert into fnd_dm_function_parameters ( 
 parameter_id	,
 parameter_name	,
 function_id)
select 28,
 'TICKET',
 25
from dual
where not exists
(select 'x'
 from fnd_dm_function_parameters
 where parameter_id = 28);


prompt Seeding Display

insert into fnd_dm_functions (
 function_id		     ,
 function_name		     ,
 sequence                    ,
 new_document_function       ,
 existing_document_function  ,
 resource_name               ,
 icon_name                   )     
select 
 30, 
 'get_display_document_url',
 30,
 'N',
 'Y',
 'WFDM_DISPLAY',
 'view.gif'
from dual
where not exists 
(select 'x'
 from  fnd_dm_functions 
 where function_id = 30);

insert into fnd_dm_function_parameters ( 
 parameter_id	,
 parameter_name	,
 function_id)
select 30, 
 'DOCUMENT_ID',
 30
from dual
where not exists
(select 'x'
 from fnd_dm_function_parameters
 where parameter_id = 30);

insert into fnd_dm_function_parameters ( 
 parameter_id	,
 parameter_name	,
 function_id)
select 31, 
 'VERSION',
 30
from dual
where not exists
(select 'x'
 from fnd_dm_function_parameters
 where parameter_id = 31);

insert into fnd_dm_function_parameters ( 
 parameter_id	,
 parameter_name	,
 function_id)
select 32,
 'USERNAME',
 30
from dual
where not exists
(select 'x'
 from fnd_dm_function_parameters
 where parameter_id = 32);

insert into fnd_dm_function_parameters ( 
 parameter_id	,
 parameter_name	,
 function_id)
select 34,
 'TICKET',
 30
from dual
where not exists
(select 'x'
 from fnd_dm_function_parameters
 where parameter_id = 34);



prompt Seeding Fetch

insert into fnd_dm_functions (
 function_id		     ,
 function_name		     ,
 sequence                    ,
 new_document_function       ,
 existing_document_function  ,
 resource_name               ,
 icon_name                   )     
select 
 40, 
 'get_fetch_document_url',
 40,
 'N',
 'Y',
 'WFDM_FETCH',
 'fetch.gif'
from dual
where not exists 
(select 'x'
 from  fnd_dm_functions 
 where function_id = 40);

insert into fnd_dm_function_parameters ( 
 parameter_id	,
 parameter_name	,
 function_id)
select 40, 
 'DOCUMENT_ID',
 40
from dual
where not exists
(select 'x'
 from fnd_dm_function_parameters
 where parameter_id = 40);

insert into fnd_dm_function_parameters ( 
 parameter_id	,
 parameter_name	,
 function_id)
select 41, 
 'VERSION',
 40
from dual
where not exists
(select 'x'
 from fnd_dm_function_parameters
 where parameter_id = 41);

insert into fnd_dm_function_parameters ( 
 parameter_id	,
 parameter_name	,
 function_id)
select 42,
 'USERNAME',
 40
from dual
where not exists
(select 'x'
 from fnd_dm_function_parameters
 where parameter_id = 42);

insert into fnd_dm_function_parameters ( 
 parameter_id	,
 parameter_name	,
 function_id)
select 44,
 'TICKET',
 40
from dual
where not exists
(select 'x'
 from fnd_dm_function_parameters
 where parameter_id = 44);


prompt Seeding Check Out

insert into fnd_dm_functions (
 function_id		     ,
 function_name		     ,
 sequence                    ,
 new_document_function       ,
 existing_document_function  ,
 resource_name               ,
 icon_name                   )     
select 
 50, 
 'get_check_out_document_url',
 50,
 'N',
 'Y',
 'WFDM_CHECK_OUT',
 'checkout.gif'
from dual
where not exists 
(select 'x'
 from  fnd_dm_functions 
 where function_id = 50);

insert into fnd_dm_function_parameters ( 
 parameter_id	,
 parameter_name	,
 function_id)
select 50, 
 'DOCUMENT_ID',
 50
from dual
where not exists
(select 'x'
 from fnd_dm_function_parameters
 where parameter_id = 50);


insert into fnd_dm_function_parameters ( 
 parameter_id	,
 parameter_name	,
 function_id)
select 52,
 'USERNAME',
 50
from dual
where not exists
(select 'x'
 from fnd_dm_function_parameters
 where parameter_id = 52);

insert into fnd_dm_function_parameters ( 
 parameter_id	,
 parameter_name	,
 function_id)
select 54,
 'TICKET',
 50
from dual
where not exists
(select 'x'
 from fnd_dm_function_parameters
 where parameter_id = 54);



prompt Seeding Check In

insert into fnd_dm_functions (
 function_id		     ,
 function_name		     ,
 sequence                    ,
 new_document_function       ,
 existing_document_function  ,
 resource_name               ,
 icon_name                   )     
select 
 60, 
 'get_check_in_document_url',
 60,
 'N',
 'Y',
 'WFDM_CHECK_IN',
 'checkin.gif'
from dual
where not exists 
(select 'x'
 from  fnd_dm_functions 
 where function_id = 60);


insert into fnd_dm_function_parameters ( 
 parameter_id	,
 parameter_name	,
 function_id)
select 60, 
 'DOCUMENT_ID',
 60
from dual
where not exists
(select 'x'
 from fnd_dm_function_parameters
 where parameter_id = 60);

insert into fnd_dm_function_parameters ( 
 parameter_id	,
 parameter_name	,
 function_id)
select 61, 
 'CALLBACK',
 60
from dual
where not exists
(select 'x'
 from fnd_dm_function_parameters
 where parameter_id = 61);

insert into fnd_dm_function_parameters ( 
 parameter_id	,
 parameter_name	,
 function_id)
select 62,
 'USERNAME',
 60
from dual
where not exists
(select 'x'
 from fnd_dm_function_parameters
 where parameter_id = 62);

insert into fnd_dm_function_parameters ( 
 parameter_id	,
 parameter_name	,
 function_id)
select 64,
 'TICKET',
 60
from dual
where not exists
(select 'x'
 from fnd_dm_function_parameters
 where parameter_id = 64);



prompt Seeding Lock

insert into fnd_dm_functions (
 function_id		     ,
 function_name		     ,
 sequence                    ,
 new_document_function       ,
 existing_document_function  ,
 resource_name               ,
 icon_name                   )     
select 
 70, 
 'get_lock_document_url',
 70,
 'N',
 'Y',
 'WFDM_LOCK',
 'lock.gif'
from dual
where not exists 
(select 'x'
 from  fnd_dm_functions 
 where function_id = 70);


insert into fnd_dm_function_parameters ( 
 parameter_id	,
 parameter_name	,
 function_id)
select 70, 
 'DOCUMENT_ID',
 70
from dual
where not exists
(select 'x'
 from fnd_dm_function_parameters
 where parameter_id = 70);

insert into fnd_dm_function_parameters ( 
 parameter_id	,
 parameter_name	,
 function_id)
select 71, 
 'CALLBACK',
 70
from dual
where not exists
(select 'x'
 from fnd_dm_function_parameters
 where parameter_id = 71);

insert into fnd_dm_function_parameters ( 
 parameter_id	,
 parameter_name	,
 function_id)
select 72,
 'USERNAME',
 70
from dual
where not exists
(select 'x'
 from fnd_dm_function_parameters
 where parameter_id = 72);

insert into fnd_dm_function_parameters ( 
 parameter_id	,
 parameter_name	,
 function_id)
select 74,
 'TICKET',
 70
from dual
where not exists
(select 'x'
 from fnd_dm_function_parameters
 where parameter_id = 74);


prompt Seeding Unlock

insert into fnd_dm_functions (
 function_id		     ,
 function_name		     ,
 sequence                    ,
 new_document_function       ,
 existing_document_function  ,
 resource_name               ,
 icon_name                   )     
select 
 80, 
 'get_unlock_document_url',
 80,
 'N',
 'Y',
 'WFDM_UNLOCK',
 'unlock.gif'
from dual
where not exists 
(select 'x'
 from  fnd_dm_functions 
 where function_id = 80);


insert into fnd_dm_function_parameters ( 
 parameter_id	,
 parameter_name	,
 function_id)
select 80, 
 'DOCUMENT_ID',
 80
from dual
where not exists
(select 'x'
 from fnd_dm_function_parameters
 where parameter_id = 80);

insert into fnd_dm_function_parameters ( 
 parameter_id	,
 parameter_name	,
 function_id)
select 81, 
 'CALLBACK',
 80
from dual
where not exists
(select 'x'
 from fnd_dm_function_parameters
 where parameter_id = 81);

insert into fnd_dm_function_parameters ( 
 parameter_id	,
 parameter_name	,
 function_id)
select 82,
 'USERNAME',
 80
from dual
where not exists
(select 'x'
 from fnd_dm_function_parameters
 where parameter_id = 82);

insert into fnd_dm_function_parameters ( 
 parameter_id	,
 parameter_name	,
 function_id)
select 84,
 'TICKET',
 80
from dual
where not exists
(select 'x'
 from fnd_dm_function_parameters
 where parameter_id = 84);



prompt Seeding Display History

insert into fnd_dm_functions (
 function_id		     ,
 function_name		     ,
 sequence                    ,
 new_document_function       ,
 existing_document_function  ,
 resource_name               ,
 icon_name                   )     
select 
 90, 
 'get_display_history_url',
 90,
 'N',
 'Y',
 'WFDM_DISPLAY_HISTORY',
 'history.gif'
from dual
where not exists 
(select 'x'
 from  fnd_dm_functions 
 where function_id = 90);


insert into fnd_dm_function_parameters ( 
 parameter_id	,
 parameter_name	,
 function_id)
select 90, 
 'DOCUMENT_ID',
 90
from dual
where not exists
(select 'x'
 from fnd_dm_function_parameters
 where parameter_id = 90);

insert into fnd_dm_function_parameters ( 
 parameter_id	,
 parameter_name	,
 function_id)
select 92,
 'USERNAME',
 90
from dual
where not exists
(select 'x'
 from fnd_dm_function_parameters
 where parameter_id = 92);

insert into fnd_dm_function_parameters ( 
 parameter_id	,
 parameter_name	,
 function_id)
select 94,
 'TICKET',
 90
from dual
where not exists
(select 'x'
 from fnd_dm_function_parameters
 where parameter_id = 94);

COMMIT;


REM FND_DM_PRODUCT_FUNCTION_SYNTAX

prompt Delete the Internet Documents and OpenText Entries

delete from fnd_dm_product_parm_syntax parm
where exists 
(select 'Internet Documents and OpenText Entries'
 from   fnd_dm_product_function_syntax func
 where  parm.product_function_id = func.product_function_id
 and    func.product_id in (1,10));

delete from fnd_dm_product_function_syntax where product_id in (1,10);

REM Search

prompt OpenText

insert into fnd_dm_product_function_syntax
(
 product_function_id,
 product_id	    ,
 function_id	    ,
 function_syntax    
)
select 
 10,
 10,
 10,
 '/Livelink/livelink.exe?func=sbroker.searchprompt&TypeOfSearchPage=New'
from dual
where not exists
(select 'x'
 from   fnd_dm_product_function_syntax
 where  product_function_id = 10);

insert into fnd_dm_product_parm_syntax (
 product_parameter_id  ,
 product_function_id   ,
 parameter_id	       ,
 parameter_syntax      ,
 format                )
select 
 10,
 10,
 10,
 'Callback=',
 null
from dual
where not exists
(select 'x'
 from fnd_dm_product_parm_syntax
 where product_parameter_id = 10);



prompt Internet Documents

insert into fnd_dm_product_function_syntax
(
 product_function_id,
 product_id	    ,
 function_id	    ,
 function_syntax    
)
select 
 1,
 1,
 10,
 '/jbc/aol/Oasjbc?template=dm_create.htm&error=error&method=service=new+'||
 'LibraryService()&method=libSession=service.connect(String+user,String+'||
 'psswd,String+server)&user=tuser1&psswd=tuser1&server=idocdemo&method=up='||
 'libSession.getPrimaryUserProfile()&method=appSession=new+'||
 'ApplicationSession(LibrarySession+sess)&sess=libSession&method=s=libSession'
from dual
where not exists
(select 'x'
 from   fnd_dm_product_function_syntax
 where  product_function_id = 1);

insert into fnd_dm_product_parm_syntax (
 product_parameter_id  ,
 product_function_id   ,
 parameter_id	       ,
 parameter_syntax      ,
 format                )
select 
 1,
 1,
 10,
 'method=Callback=new+String(String+str)&str=',
 null
from dual
where not exists
(select 'x'
 from fnd_dm_product_parm_syntax
 where product_parameter_id = 1);

prompt Seeding Add

insert into fnd_dm_product_function_syntax
(
 product_function_id,
 product_id	    ,
 function_id	    ,
 function_syntax    
)
select 
 20,
 10,
 20,
 '/Livelink/livelink.exe?func=ll&objType=144&objAction=create&nextURL='
from dual
where not exists
(select 'x'
 from   fnd_dm_product_function_syntax
 where  product_function_id = 20);

insert into fnd_dm_product_parm_syntax (
 product_parameter_id  ,
 product_function_id   ,
 parameter_id	       ,
 parameter_syntax      ,
 format                )
select 
 20,
 20,
 20,
 'Callback=',
 null
from dual
where not exists
(select 'x'
 from fnd_dm_product_parm_syntax
 where product_parameter_id = 20);

prompt Seeding Browse

insert into fnd_dm_product_function_syntax
(
 product_function_id,
 product_id	    ,
 function_id	    ,
 function_syntax    
)
select 
 25,
 10,
 25,
 '/Livelink/livelink.exe?func=ll&objID=2000&objAction=TargetBrowse&'||
 'headerLabel=Select+Document+to+Attach...&selectLabel=Select&selectScreen'||
 '={0,136,141,142,154,201,206,208,276}&formname=createform&fieldprefix=ATT'
from dual
where not exists
(select 'x'
 from   fnd_dm_product_function_syntax
 where  product_function_id = 25);

insert into fnd_dm_product_parm_syntax (
 product_parameter_id  ,
 product_function_id   ,
 parameter_id	       ,
 parameter_syntax      ,
 format                )
select 
 25,
 25,
 25,
 'Callback=',
 null
from dual
where not exists
(select 'x'
 from fnd_dm_product_parm_syntax
 where product_parameter_id = 25);

prompt Seeding Display

REM OpenText

insert into fnd_dm_product_function_syntax
(
 product_function_id,
 product_id	    ,
 function_id	    ,
 function_syntax    
)
select 
 30,
 10,
 30,
 '/Livelink/llview.exe/Document?func=doc.view'
from dual
where not exists
(select 'x'
 from   fnd_dm_product_function_syntax
 where  product_function_id = 30);


insert into fnd_dm_product_parm_syntax (
 product_parameter_id  ,
 product_function_id   ,
 parameter_id	       ,
 parameter_syntax      ,
 format                )
select 
 30,
 30,
 30,
 'nodeId=',
 null
from dual
where not exists
(select 'x'
 from fnd_dm_product_parm_syntax
 where product_parameter_id = 30);

insert into fnd_dm_product_parm_syntax (
 product_parameter_id  ,
 product_function_id   ,
 parameter_id	       ,
 parameter_syntax      ,
 format                )
select 
 31,
 30,
 31,
 'vernum=',
 null
from dual
where not exists
(select 'x'
 from fnd_dm_product_parm_syntax
 where product_parameter_id = 31);



REM Internet Documents

insert into fnd_dm_product_function_syntax
(
 product_function_id,
 product_id	    ,
 function_id	    ,
 function_syntax    
)
select 
 3,
 1,
 30,
'/jbc/aol/Oasjbc?template=dm_check_doc.htm&error=error&method=service=new+'||
'LibraryService()&method=libSession=service.connect(String+user,String+psswd'||
',String+server)&user=tuser1&psswd=tuser1&server=idocdemo&method=up='||
'libSession.getPrimaryUserProfile()&method=appSession=new+ApplicationSession'||
'(LibrarySession+sess)&sess=libSession&method=s=libSession&method=obj='||
's.getPublicObject(Long+docId)'
from dual
where not exists
(select 'x'
 from   fnd_dm_product_function_syntax
 where  product_function_id = 3);


insert into fnd_dm_product_parm_syntax (
 product_parameter_id  ,
 product_function_id   ,
 parameter_id	       ,
 parameter_syntax      ,
 format                )
select 
 5,
 3,
 30,
 'docId=',
 null
from dual
where not exists
(select 'x'
 from fnd_dm_product_parm_syntax
 where product_parameter_id = 5);



prompt Seeding Fetch

insert into fnd_dm_product_function_syntax
(
 product_function_id,
 product_id	    ,
 function_id	    ,
 function_syntax    
)
select 
 40,
 10,
 40,
 '/Livelink/livelink.exe/Document?func=doc.fetch'
from dual
where not exists
(select 'x'
 from   fnd_dm_product_function_syntax
 where  product_function_id = 40);

insert into fnd_dm_product_parm_syntax (
 product_parameter_id  ,
 product_function_id   ,
 parameter_id	       ,
 parameter_syntax      ,
 format                )
select 
 40,
 40,
 40,
 'nodeId=',
 null
from dual
where not exists
(select 'x'
 from fnd_dm_product_parm_syntax
 where product_parameter_id = 40);
insert into fnd_dm_product_parm_syntax (
 product_parameter_id  ,
 product_function_id   ,
 parameter_id	       ,
 parameter_syntax      ,
 format                )
select 
 41,
 40,
 41,
 'vernum=',
 null
from dual
where not exists
(select 'x'
 from fnd_dm_product_parm_syntax
 where product_parameter_id = 41);



prompt Seeding Check Out

insert into fnd_dm_product_function_syntax
(
 product_function_id,
 product_id	    ,
 function_id	    ,
 function_syntax    
)
select 
 50,
 10,
 50,
 '/Livelink/livelink.exe?func=ll&objaction=checkout'
from dual
where not exists
(select 'x'
 from   fnd_dm_product_function_syntax
 where  product_function_id = 50);

insert into fnd_dm_product_parm_syntax (
 product_parameter_id  ,
 product_function_id   ,
 parameter_id	       ,
 parameter_syntax      ,
 format                )
select 
 50,
 50,
 50,
 'objId=',
 null
from dual
where not exists
(select 'x'
 from fnd_dm_product_parm_syntax
 where product_parameter_id = 50);


prompt Seeding Check In

insert into fnd_dm_product_function_syntax
(
 product_function_id,
 product_id	    ,
 function_id	    ,
 function_syntax    
)
select 
 60,
 10,
 60,
 '/Livelink/livelink.exe?func=doc.checkin'
from dual
where not exists
(select 'x'
 from   fnd_dm_product_function_syntax
 where  product_function_id = 60);


insert into fnd_dm_product_parm_syntax (
 product_parameter_id  ,
 product_function_id   ,
 parameter_id	       ,
 parameter_syntax      ,
 format                )
select 
 60,
 60,
 60,
 'nodeId=',
 null
from dual
where not exists
(select 'x'
 from fnd_dm_product_parm_syntax
 where product_parameter_id = 60);


insert into fnd_dm_product_parm_syntax (
 product_parameter_id  ,
 product_function_id   ,
 parameter_id	       ,
 parameter_syntax      ,
 format                )
select 
 61,
 60,
 61,
 'nextURL=',
 null
from dual
where not exists
(select 'x'
 from fnd_dm_product_parm_syntax
 where product_parameter_id = 61);


prompt Seeding Lock

insert into fnd_dm_product_function_syntax
(
 product_function_id,
 product_id	    ,
 function_id	    ,
 function_syntax    
)
select 
 70,
 10,
 70,
 '/Livelink/livelink.exe?func=doc.reserve'
from dual
where not exists
(select 'x'
 from   fnd_dm_product_function_syntax
 where  product_function_id = 70);


insert into fnd_dm_product_parm_syntax (
 product_parameter_id  ,
 product_function_id   ,
 parameter_id	       ,
 parameter_syntax      ,
 format                )
select 
 70,
 70,
 70,
 'nodeId=',
 null
from dual
where not exists
(select 'x'
 from fnd_dm_product_parm_syntax
 where product_parameter_id = 70);


insert into fnd_dm_product_parm_syntax (
 product_parameter_id  ,
 product_function_id   ,
 parameter_id	       ,
 parameter_syntax      ,
 format                )
select 
 71,
 70,
 71,
 'nextURL=',
 null
from dual
where not exists
(select 'x'
 from fnd_dm_product_parm_syntax
 where product_parameter_id = 71);


prompt Seeding Unlock

insert into fnd_dm_product_function_syntax
(
 product_function_id,
 product_id	    ,
 function_id	    ,
 function_syntax    
)
select 
 80,
 10,
 80,
 '/Livelink/livelink.exe?func=doc.unreserve'
from dual
where not exists
(select 'x'
 from   fnd_dm_product_function_syntax
 where  product_function_id = 80);


insert into fnd_dm_product_parm_syntax (
 product_parameter_id  ,
 product_function_id   ,
 parameter_id	       ,
 parameter_syntax      ,
 format                )
select 
 80,
 80,
 80,
 'nodeId=',
 null
from dual
where not exists
(select 'x'
 from fnd_dm_product_parm_syntax
 where product_parameter_id = 80);


insert into fnd_dm_product_parm_syntax (
 product_parameter_id  ,
 product_function_id   ,
 parameter_id	       ,
 parameter_syntax      ,
 format                )
select 
 81,
 80,
 81,
 'nextURL=',
 null
from dual
where not exists
(select 'x'
 from fnd_dm_product_parm_syntax
 where product_parameter_id = 81);


prompt Display History

insert into fnd_dm_product_function_syntax
(
 product_function_id,
 product_id	    ,
 function_id	    ,
 function_syntax    
)
select 
 90,
 10,
 90,
 '/Livelink/livelink.exe?func=ll&objaction=properties'
from dual
where not exists
(select 'x'
 from   fnd_dm_product_function_syntax
 where  product_function_id = 90);


insert into fnd_dm_product_parm_syntax (
 product_parameter_id  ,
 product_function_id   ,
 parameter_id	       ,
 parameter_syntax      ,
 format                )
select 
 90,
 90,
 90,
 'objid=',
 null
from dual
where not exists
(select 'x'
 from fnd_dm_product_parm_syntax
 where product_parameter_id = 90);

COMMIT;

EXIT;


