REM $Header: afsvcc.sql 26.2 2003/02/05 03:26:26 sacsharm ship $
REM +======================================================================+
REM | Copyright (c) 1995 Oracle Corporation Redwood Shores, California, USA|
REM |                       All rights reserved.                           |
REM +======================================================================+
REM
REM NAME
REM     afsvcc.sql  -  Script to create Generic Service Components tables
REM                    and Sequences
REM
REM MODIFICATION LOG
REM	11/2002 SACSHARM CREATED 
REM +======================================================================+

REM Connect to base account
REM (autopatch will run all scripts in apps account)
connect &1/&2;

REM Continue in case of error where tables aready exist
WHENEVER SQLERROR CONTINUE;

PROMPT Creating Table 'FND_SVC_COMPONENTS'
CREATE TABLE FND_SVC_COMPONENTS
 (COMPONENT_ID NUMBER NOT NULL
 ,COMPONENT_NAME VARCHAR2(80) NOT NULL
 ,COMPONENT_STATUS VARCHAR2(30) NOT NULL
 ,COMPONENT_TYPE VARCHAR2(30) NOT NULL
 ,STARTUP_MODE VARCHAR2(30) NOT NULL
 ,CONTAINER_TYPE VARCHAR2(30) NOT NULL
 ,CUSTOMIZATION_LEVEL VARCHAR2(30) NOT NULL
 ,APPLICATION_ID NUMBER
 ,CONCURRENT_QUEUE_ID NUMBER
 ,STANDALONE_CONTAINER_NAME VARCHAR2(30)
 ,INBOUND_AGENT_NAME VARCHAR2(30)
 ,OUTBOUND_AGENT_NAME VARCHAR2(30)
 ,CORRELATION_ID VARCHAR2(240)
 ,MAX_IDLE_TIME NUMBER
 ,COMPONENT_STATUS_INFO VARCHAR2(1996)
 ,CREATION_DATE DATE NOT NULL
 ,CREATED_BY NUMBER(15) NOT NULL
 ,LAST_UPDATE_DATE DATE NOT NULL
 ,LAST_UPDATED_BY NUMBER(15) NOT NULL
 ,LAST_UPDATE_LOGIN NUMBER(15)
 ,OBJECT_VERSION_NUMBER NUMBER NOT NULL
 )
/

COMMENT ON TABLE FND_SVC_COMPONENTS IS 'Service Components'
/

COMMENT ON COLUMN FND_SVC_COMPONENTS.COMPONENT_ID IS 'Identifier'
/

COMMENT ON COLUMN FND_SVC_COMPONENTS.COMPONENT_NAME IS 'User-defined name for the Service Component.  User interface may accept only 26 characters for this field'
/

COMMENT ON COLUMN FND_SVC_COMPONENTS.COMPONENT_STATUS IS 'Status of the Service Component.  This is run-time data'
/

COMMENT ON COLUMN FND_SVC_COMPONENTS.COMPONENT_TYPE IS 'Service Component-Type of the Service Component'
/

COMMENT ON COLUMN FND_SVC_COMPONENTS.STARTUP_MODE IS 'Startup mode of the Service Component'
/

COMMENT ON COLUMN FND_SVC_COMPONENTS.CONTAINER_TYPE IS 'Source type for the Service Component Container'
/

COMMENT ON COLUMN FND_SVC_COMPONENTS.CUSTOMIZATION_LEVEL IS 'Specifies the extent to which the Service Component has been/can be customized'
/

COMMENT ON COLUMN FND_SVC_COMPONENTS.APPLICATION_ID IS 'If CONTAINER_TYPE column  is ''GSM'', this is the APPLICATION_ID column of FND_CONCURRENT_QUEUES'
/

COMMENT ON COLUMN FND_SVC_COMPONENTS.CONCURRENT_QUEUE_ID IS 'If CONTAINER_TYPE column is ''GSM'', this is the CONCURRENT_QUEUE_ID of  the FND_CONCURRENT_QUEUES_TABLE'
/

COMMENT ON COLUMN FND_SVC_COMPONENTS.STANDALONE_CONTAINER_NAME IS 'If CONTAINER_TYPE column is ''SERVLET'', this is the name of Service Component Container'
/

COMMENT ON COLUMN FND_SVC_COMPONENTS.INBOUND_AGENT_NAME IS 'Inbound agent name for the Service Component'
/

COMMENT ON COLUMN FND_SVC_COMPONENTS.OUTBOUND_AGENT_NAME IS 'Outbound agent name for the Service Component'
/

COMMENT ON COLUMN FND_SVC_COMPONENTS.CORRELATION_ID IS 'Identifier of correlating entity, if any.  User interface may accept only 128 characters for this field'
/

COMMENT ON COLUMN FND_SVC_COMPONENTS.MAX_IDLE_TIME IS 'If STARTUP_MODE column is ''ON_DEMAND'', this is the maximum time in minutes that the Service Component can be idle before it is stopped'
/

COMMENT ON COLUMN FND_SVC_COMPONENTS.COMPONENT_STATUS_INFO IS 'Information regarding to the Service Component''s status.  This is run-time data'
/

COMMENT ON COLUMN FND_SVC_COMPONENTS.CREATION_DATE IS 'Standard Who column'
/

COMMENT ON COLUMN FND_SVC_COMPONENTS.CREATED_BY IS 'Standard Who column'
/

COMMENT ON COLUMN FND_SVC_COMPONENTS.LAST_UPDATE_DATE IS 'Standard Who column'
/

COMMENT ON COLUMN FND_SVC_COMPONENTS.LAST_UPDATED_BY IS 'Standard Who column'
/

COMMENT ON COLUMN FND_SVC_COMPONENTS.LAST_UPDATE_LOGIN IS 'Standard Who column'
/

COMMENT ON COLUMN FND_SVC_COMPONENTS.OBJECT_VERSION_NUMBER IS 'Object version number required for user interface'
/

PROMPT Creating Table 'FND_SVC_COMP_REQUESTS'
CREATE TABLE FND_SVC_COMP_REQUESTS
 (COMPONENT_REQUEST_ID NUMBER NOT NULL
 ,COMPONENT_ID NUMBER NOT NULL
 ,EVENT_NAME VARCHAR2(240) NOT NULL
 ,EVENT_DATE DATE NOT NULL
 ,REQUESTED_BY_USER VARCHAR2(320)
 ,JOB_ID NUMBER NOT NULL
 ,EVENT_PARAMS VARCHAR2(1996)
 ,EVENT_FREQUENCY NUMBER
 ,CREATION_DATE DATE NOT NULL
 ,CREATED_BY NUMBER(15) NOT NULL
 ,LAST_UPDATE_DATE DATE NOT NULL
 ,LAST_UPDATED_BY NUMBER(15) NOT NULL
 ,LAST_UPDATE_LOGIN NUMBER(15)
 ,OBJECT_VERSION_NUMBER NUMBER NOT NULL
 )
/

COMMENT ON TABLE FND_SVC_COMP_REQUESTS IS 'Scheduled Service Component Events'
/

COMMENT ON COLUMN FND_SVC_COMP_REQUESTS.COMPONENT_REQUEST_ID IS 'Identifier'
/

COMMENT ON COLUMN FND_SVC_COMP_REQUESTS.COMPONENT_ID IS 'Service Component for which the request has been scheduled'
/

COMMENT ON COLUMN FND_SVC_COMP_REQUESTS.EVENT_NAME IS 'Name of the event that the request will raise'
/

COMMENT ON COLUMN FND_SVC_COMP_REQUESTS.EVENT_DATE IS 'Time when the request should start'
/

COMMENT ON COLUMN FND_SVC_COMP_REQUESTS.REQUESTED_BY_USER IS 'User who scheduled the request'
/

COMMENT ON COLUMN FND_SVC_COMP_REQUESTS.JOB_ID IS 'Job Id for the submitted request; run-time data'
/

COMMENT ON COLUMN FND_SVC_COMP_REQUESTS.EVENT_PARAMS IS 'Parameters for the request.  User interface may accept only 665 characters for this field'
/

COMMENT ON COLUMN FND_SVC_COMP_REQUESTS.EVENT_FREQUENCY IS 'Frequency in minutes that the request should execute'
/

COMMENT ON COLUMN FND_SVC_COMP_REQUESTS.CREATION_DATE IS 'Standard Who column'
/

COMMENT ON COLUMN FND_SVC_COMP_REQUESTS.CREATED_BY IS 'Standard Who column'
/

COMMENT ON COLUMN FND_SVC_COMP_REQUESTS.LAST_UPDATE_DATE IS 'Standard Who column'
/

COMMENT ON COLUMN FND_SVC_COMP_REQUESTS.LAST_UPDATED_BY IS 'Standard Who column'
/

COMMENT ON COLUMN FND_SVC_COMP_REQUESTS.LAST_UPDATE_LOGIN IS 'Standard Who column'
/

COMMENT ON COLUMN FND_SVC_COMP_REQUESTS.OBJECT_VERSION_NUMBER IS 'Object version number required for user interface'
/

PROMPT Creating Table 'FND_SVC_COMP_PARAMS_TL'
CREATE TABLE FND_SVC_COMP_PARAMS_TL
 (PARAMETER_ID NUMBER NOT NULL
 ,LANGUAGE VARCHAR2(4) NOT NULL
 ,SOURCE_LANG VARCHAR2(4) NOT NULL
 ,DISPLAY_NAME VARCHAR2(80) NOT NULL
 ,DESCRIPTION VARCHAR2(1996)
 ,CREATION_DATE DATE NOT NULL
 ,CREATED_BY NUMBER(15) NOT NULL
 ,LAST_UPDATE_DATE DATE NOT NULL
 ,LAST_UPDATED_BY NUMBER(15) NOT NULL
 ,LAST_UPDATE_LOGIN NUMBER(15)
 )
/

COMMENT ON TABLE FND_SVC_COMP_PARAMS_TL IS 'MLS table for the FND_SVC_COMP_PARAMS_B table'
/

COMMENT ON COLUMN FND_SVC_COMP_PARAMS_TL.PARAMETER_ID IS 'Identifier for the Service Component parameter definition'
/

COMMENT ON COLUMN FND_SVC_COMP_PARAMS_TL.LANGUAGE IS 'Language to which things are translated'
/

COMMENT ON COLUMN FND_SVC_COMP_PARAMS_TL.SOURCE_LANG IS 'Language from which things are translated'
/

COMMENT ON COLUMN FND_SVC_COMP_PARAMS_TL.DISPLAY_NAME IS 'Language-dependent name for the parameter.  User interface may accept only 26 characters for this field'
/

COMMENT ON COLUMN FND_SVC_COMP_PARAMS_TL.DESCRIPTION IS 'Language-dependent description for the parameter.  User interface may accept only 665 characters for this field'
/

COMMENT ON COLUMN FND_SVC_COMP_PARAMS_TL.CREATION_DATE IS 'Standard Who column'
/

COMMENT ON COLUMN FND_SVC_COMP_PARAMS_TL.CREATED_BY IS 'Standard Who column'
/

COMMENT ON COLUMN FND_SVC_COMP_PARAMS_TL.LAST_UPDATE_DATE IS 'Standard Who column'
/

COMMENT ON COLUMN FND_SVC_COMP_PARAMS_TL.LAST_UPDATED_BY IS 'Standard Who column'
/

COMMENT ON COLUMN FND_SVC_COMP_PARAMS_TL.LAST_UPDATE_LOGIN IS 'Standard Who column'
/

PROMPT Creating Table 'FND_SVC_COMP_TYPES_B'
CREATE TABLE FND_SVC_COMP_TYPES_B
 (COMPONENT_TYPE VARCHAR2(30) NOT NULL
 ,COMPONENT_CLASS_NAME VARCHAR2(240) NOT NULL
 ,CONFIG_UI_REGION VARCHAR2(240) NOT NULL
 ,CUSTOMIZATION_LEVEL VARCHAR2(30) NOT NULL
 ,CREATION_DATE DATE NOT NULL
 ,CREATED_BY NUMBER(15) NOT NULL
 ,LAST_UPDATE_DATE DATE NOT NULL
 ,LAST_UPDATED_BY NUMBER(15) NOT NULL
 ,LAST_UPDATE_LOGIN NUMBER(15)
 ,OBJECT_VERSION_NUMBER NUMBER NOT NULL
 )
/

COMMENT ON TABLE FND_SVC_COMP_TYPES_B IS 'Service Component-Types'
/

COMMENT ON COLUMN FND_SVC_COMP_TYPES_B.COMPONENT_TYPE IS 'Identifier'
/

COMMENT ON COLUMN FND_SVC_COMP_TYPES_B.COMPONENT_CLASS_NAME IS 'Fully qualified Java class name of the Service Component'
/

COMMENT ON COLUMN FND_SVC_COMP_TYPES_B.CONFIG_UI_REGION IS 'Name of page for configuring the Service Component-Type'
/

COMMENT ON COLUMN FND_SVC_COMP_TYPES_B.CUSTOMIZATION_LEVEL IS 'Specifies the extent to which the Service Component-Type has been/can be customized'
/

COMMENT ON COLUMN FND_SVC_COMP_TYPES_B.CREATION_DATE IS 'Standard Who column'
/

COMMENT ON COLUMN FND_SVC_COMP_TYPES_B.CREATED_BY IS 'Standard Who column'
/

COMMENT ON COLUMN FND_SVC_COMP_TYPES_B.LAST_UPDATE_DATE IS 'Standard Who column'
/

COMMENT ON COLUMN FND_SVC_COMP_TYPES_B.LAST_UPDATED_BY IS 'Standard Who column'
/

COMMENT ON COLUMN FND_SVC_COMP_TYPES_B.LAST_UPDATE_LOGIN IS 'Standard Who column'
/

COMMENT ON COLUMN FND_SVC_COMP_TYPES_B.OBJECT_VERSION_NUMBER IS 'Object version number required for user interface'
/

PROMPT Creating Table 'FND_SVC_COMP_TYPES_TL'
CREATE TABLE FND_SVC_COMP_TYPES_TL
 (COMPONENT_TYPE VARCHAR2(30) NOT NULL
 ,LANGUAGE VARCHAR2(4) NOT NULL
 ,SOURCE_LANG VARCHAR2(4) NOT NULL
 ,DISPLAY_NAME VARCHAR2(80) NOT NULL
 ,DESCRIPTION VARCHAR2(1996)
 ,CREATION_DATE DATE NOT NULL
 ,CREATED_BY NUMBER(15) NOT NULL
 ,LAST_UPDATE_DATE DATE NOT NULL
 ,LAST_UPDATED_BY NUMBER(15) NOT NULL
 ,LAST_UPDATE_LOGIN NUMBER(15)
 )
/

COMMENT ON TABLE FND_SVC_COMP_TYPES_TL IS 'MLS table for the FND_SVC_COMP_TYPES_B table'
/

COMMENT ON COLUMN FND_SVC_COMP_TYPES_TL.COMPONENT_TYPE IS 'Identifier for the Service Component-Type'
/

COMMENT ON COLUMN FND_SVC_COMP_TYPES_TL.LANGUAGE IS 'Language to which things are translated'
/

COMMENT ON COLUMN FND_SVC_COMP_TYPES_TL.SOURCE_LANG IS 'Language from which things are translated'
/

COMMENT ON COLUMN FND_SVC_COMP_TYPES_TL.DISPLAY_NAME IS 'Language-dependent name for the Service Component-Type.User interface may accept only 26 characters for this field.'
/

COMMENT ON COLUMN FND_SVC_COMP_TYPES_TL.DESCRIPTION IS 'Language-dependent description for the Service Component-Type.User interface may accept only 665 characters for this field'
/

COMMENT ON COLUMN FND_SVC_COMP_TYPES_TL.CREATION_DATE IS 'Standard Who column'
/

COMMENT ON COLUMN FND_SVC_COMP_TYPES_TL.CREATED_BY IS 'Standard Who column'
/

COMMENT ON COLUMN FND_SVC_COMP_TYPES_TL.LAST_UPDATE_DATE IS 'Standard Who column'
/

COMMENT ON COLUMN FND_SVC_COMP_TYPES_TL.LAST_UPDATED_BY IS 'Standard Who column'
/

COMMENT ON COLUMN FND_SVC_COMP_TYPES_TL.LAST_UPDATE_LOGIN IS 'Standard Who column'
/

PROMPT Creating Table 'FND_SVC_COMP_PARAM_VALS'
CREATE TABLE FND_SVC_COMP_PARAM_VALS
 (COMPONENT_PARAMETER_ID NUMBER NOT NULL
 ,COMPONENT_ID NUMBER NOT NULL
 ,PARAMETER_ID NUMBER NOT NULL
 ,PARAMETER_VALUE VARCHAR2(1996)
 ,CUSTOMIZATION_LEVEL VARCHAR2(30) NOT NULL
 ,CREATION_DATE DATE NOT NULL
 ,CREATED_BY NUMBER(15) NOT NULL
 ,LAST_UPDATE_DATE DATE NOT NULL
 ,LAST_UPDATED_BY NUMBER(15) NOT NULL
 ,LAST_UPDATE_LOGIN NUMBER(15)
 ,OBJECT_VERSION_NUMBER NUMBER NOT NULL
 )
/

COMMENT ON TABLE FND_SVC_COMP_PARAM_VALS IS 'Service Component Parameter Values'
/

COMMENT ON COLUMN FND_SVC_COMP_PARAM_VALS.COMPONENT_PARAMETER_ID IS 'Identifier'
/

COMMENT ON COLUMN FND_SVC_COMP_PARAM_VALS.COMPONENT_ID IS 'Identifier for the Service Component for which the parameter value has been configured'
/

COMMENT ON COLUMN FND_SVC_COMP_PARAM_VALS.PARAMETER_ID IS 'Identifier for the Service Component-Type parameter definition'
/

COMMENT ON COLUMN FND_SVC_COMP_PARAM_VALS.PARAMETER_VALUE IS 'Value of the parameter.  User interface may accept only 665 characters for this field'
/

COMMENT ON COLUMN FND_SVC_COMP_PARAM_VALS.CUSTOMIZATION_LEVEL IS 'Specifies the extent to which the parameter value has been/can be customized'
/

COMMENT ON COLUMN FND_SVC_COMP_PARAM_VALS.CREATION_DATE IS 'Standard Who column'
/

COMMENT ON COLUMN FND_SVC_COMP_PARAM_VALS.CREATED_BY IS 'Standard Who column'
/

COMMENT ON COLUMN FND_SVC_COMP_PARAM_VALS.LAST_UPDATE_DATE IS 'Standard Who column'
/

COMMENT ON COLUMN FND_SVC_COMP_PARAM_VALS.LAST_UPDATED_BY IS 'Standard Who column'
/

COMMENT ON COLUMN FND_SVC_COMP_PARAM_VALS.LAST_UPDATE_LOGIN IS 'Standard Who column'
/

COMMENT ON COLUMN FND_SVC_COMP_PARAM_VALS.OBJECT_VERSION_NUMBER IS 'Object version number required for user interface'
/

PROMPT Creating Table 'FND_SVC_COMP_REQUESTS_H'
CREATE TABLE FND_SVC_COMP_REQUESTS_H
 (REQUEST_HISTORY_ID NUMBER NOT NULL
 ,COMPONENT_ID NUMBER NOT NULL
 ,EVENT_NAME VARCHAR2(240) NOT NULL
 ,REQUEST_STATUS VARCHAR2(30) NOT NULL
 ,REQUESTED_BY_USER VARCHAR2(320)
 ,COMPLETION_DATE DATE NOT NULL
 ,COMPONENT_NAME VARCHAR2(80) NOT NULL
 ,COMPONENT_STATUS VARCHAR2(30) NOT NULL
 ,COMPONENT_TYPE VARCHAR2(30) NOT NULL
 ,CONTAINER_TYPE VARCHAR2(30) NOT NULL
 ,CONTAINER_NAME VARCHAR2(30) NOT NULL
 ,EVENT_PARAMS VARCHAR2(1996)
 ,CREATION_DATE DATE NOT NULL
 ,CREATED_BY NUMBER(15) NOT NULL
 ,LAST_UPDATE_DATE DATE NOT NULL
 ,LAST_UPDATED_BY NUMBER(15) NOT NULL
 ,LAST_UPDATE_LOGIN NUMBER(15)
 ,OBJECT_VERSION_NUMBER NUMBER NOT NULL
 )
/

COMMENT ON TABLE FND_SVC_COMP_REQUESTS_H IS 'Service Component Event Requests History'
/

COMMENT ON COLUMN FND_SVC_COMP_REQUESTS_H.REQUEST_HISTORY_ID IS 'Identifier'
/

COMMENT ON COLUMN FND_SVC_COMP_REQUESTS_H.COMPONENT_ID IS 'Snapshot of COMPONENT_ID column in FND_SVC_COMPONENTS table'
/

COMMENT ON COLUMN FND_SVC_COMP_REQUESTS_H.EVENT_NAME IS 'EVENT_NAME column in FND_SVC_COMP_REQUESTS table'
/

COMMENT ON COLUMN FND_SVC_COMP_REQUESTS_H.REQUEST_STATUS IS 'Request completion status'
/

COMMENT ON COLUMN FND_SVC_COMP_REQUESTS_H.REQUESTED_BY_USER IS 'REQUESTED_BY_USER column in FND_SVC_COMP_REQUESTS table'
/

COMMENT ON COLUMN FND_SVC_COMP_REQUESTS_H.COMPLETION_DATE IS 'Request completion date'
/

COMMENT ON COLUMN FND_SVC_COMP_REQUESTS_H.COMPONENT_NAME IS 'Snapshot of COMPONENT_NAME column in FND_SVC_COMPONENTS table'
/

COMMENT ON COLUMN FND_SVC_COMP_REQUESTS_H.COMPONENT_STATUS IS 'Snapshot of COMPONENT_STATUS column in FND_SVC_COMPONENTS table'
/

COMMENT ON COLUMN FND_SVC_COMP_REQUESTS_H.COMPONENT_TYPE IS 'Snapshot of COMPONENT_TYPE in FND_SVC_COMPONENTS table'
/

COMMENT ON COLUMN FND_SVC_COMP_REQUESTS_H.CONTAINER_TYPE IS 'Snapshot of CONTAINER_TYPE column in FND_SVC_COMPONENTS table'
/

COMMENT ON COLUMN FND_SVC_COMP_REQUESTS_H.CONTAINER_NAME IS 'Snapshot of STANDALONE_CONTAINER_NAME column in FND_SVC_COMPONENTS table if CONTAINER_TYPE column is ''SERVLET'' or CONCURRENT_QUEUE_NAME column in FND_CONCURRENT_QUEUES if CONTAINER_TYPE column is ''GSM'''
/

COMMENT ON COLUMN FND_SVC_COMP_REQUESTS_H.EVENT_PARAMS IS 'EVENT_PARAMS column in FND_SVC_COMP_REQUESTS table'
/

COMMENT ON COLUMN FND_SVC_COMP_REQUESTS_H.CREATION_DATE IS 'Standard Who column'
/

COMMENT ON COLUMN FND_SVC_COMP_REQUESTS_H.CREATED_BY IS 'Standard Who column'
/

COMMENT ON COLUMN FND_SVC_COMP_REQUESTS_H.LAST_UPDATE_DATE IS 'Standard Who column'
/

COMMENT ON COLUMN FND_SVC_COMP_REQUESTS_H.LAST_UPDATED_BY IS 'Standard Who column'
/

COMMENT ON COLUMN FND_SVC_COMP_REQUESTS_H.LAST_UPDATE_LOGIN IS 'Standard Who column'
/

COMMENT ON COLUMN FND_SVC_COMP_REQUESTS_H.OBJECT_VERSION_NUMBER IS 'Object version number required for user interface'
/

PROMPT Creating Table 'FND_SVC_COMP_PARAMS_B'
CREATE TABLE FND_SVC_COMP_PARAMS_B
 (PARAMETER_ID NUMBER NOT NULL
 ,PARAMETER_NAME VARCHAR2(30) NOT NULL
 ,COMPONENT_TYPE VARCHAR2(30) NOT NULL
 ,DEFAULT_PARAMETER_VALUE VARCHAR2(1996)
 ,REQUIRED_FLAG VARCHAR2(1) NOT NULL
 ,ALLOW_RELOAD_FLAG VARCHAR2(1) NOT NULL
 ,ENCRYPTED_FLAG VARCHAR2(1) NOT NULL
 ,CUSTOMIZATION_LEVEL VARCHAR2(30) NOT NULL
 ,CREATION_DATE DATE NOT NULL
 ,CREATED_BY NUMBER(15) NOT NULL
 ,LAST_UPDATE_DATE DATE NOT NULL
 ,LAST_UPDATED_BY NUMBER(15) NOT NULL
 ,LAST_UPDATE_LOGIN NUMBER(15)
 ,OBJECT_VERSION_NUMBER NUMBER NOT NULL
 )
/

COMMENT ON TABLE FND_SVC_COMP_PARAMS_B IS 'Service Component Parameter Definitions'
/

COMMENT ON COLUMN FND_SVC_COMP_PARAMS_B.PARAMETER_ID IS 'Identifier'
/

COMMENT ON COLUMN FND_SVC_COMP_PARAMS_B.PARAMETER_NAME IS 'Name of the parameter definition'
/

COMMENT ON COLUMN FND_SVC_COMP_PARAMS_B.COMPONENT_TYPE IS 'Service Component-Type to which the parameter definition belongs'
/

COMMENT ON COLUMN FND_SVC_COMP_PARAMS_B.DEFAULT_PARAMETER_VALUE IS 'Default value for the parameter definition.User interface may accept only 665 characters for this field.'
/

COMMENT ON COLUMN FND_SVC_COMP_PARAMS_B.REQUIRED_FLAG IS 'Y or N.  Signifies whether or not a value is required for the parameter'
/

COMMENT ON COLUMN FND_SVC_COMP_PARAMS_B.ALLOW_RELOAD_FLAG IS 'Y or N.  Signifies whether or not the parameter''s value can be refreshed at run-time'
/

COMMENT ON COLUMN FND_SVC_COMP_PARAMS_B.ENCRYPTED_FLAG IS 'Y or N.  Signifies whether or not the parameter''s value should be encrypted when storin'
/

COMMENT ON COLUMN FND_SVC_COMP_PARAMS_B.CUSTOMIZATION_LEVEL IS 'Specifies the extent to which the parameter definition has been/can be customized'
/

COMMENT ON COLUMN FND_SVC_COMP_PARAMS_B.CREATION_DATE IS 'Standard Who column'
/

COMMENT ON COLUMN FND_SVC_COMP_PARAMS_B.CREATED_BY IS 'Standard Who column'
/

COMMENT ON COLUMN FND_SVC_COMP_PARAMS_B.LAST_UPDATE_DATE IS 'Standard Who column'
/

COMMENT ON COLUMN FND_SVC_COMP_PARAMS_B.LAST_UPDATED_BY IS 'Standard Who column'
/

COMMENT ON COLUMN FND_SVC_COMP_PARAMS_B.LAST_UPDATE_LOGIN IS 'Standard Who column'
/

COMMENT ON COLUMN FND_SVC_COMP_PARAMS_B.OBJECT_VERSION_NUMBER IS 'Object version number required for user interface'
/


-- M:\sacsharm\fndcpsvc2.tab
--
-- Generated for Oracle 8.1 on Thu Oct 31  19:57:10 2002 by Server Generator 6.5.82.2.0
 
PROMPT Creating Table 'FND_CONCURRENT_QUEUES_TL'
CREATE TABLE FND_CONCURRENT_QUEUES_TL
 (APPLICATION_ID NUMBER NOT NULL
 ,CONCURRENT_QUEUE_ID NUMBER NOT NULL
 ,LANGUAGE VARCHAR2(4) NOT NULL
 ,CONCURRENT_QUEUE_NAME VARCHAR2(30) NOT NULL
 ,CREATION_DATE DATE NOT NULL
 ,CREATED_BY NUMBER(15,0) NOT NULL
 ,LAST_UPDATE_DATE DATE NOT NULL
 ,LAST_UPDATED_BY NUMBER(15,0) NOT NULL
 ,LAST_UPDATE_LOGIN NUMBER(15,0) NOT NULL
 ,DESCRIPTION VARCHAR2(240)
 ,SOURCE_LANG VARCHAR2(4) DEFAULT '??' NOT NULL
 ,USER_CONCURRENT_QUEUE_NAME VARCHAR2(240)
 )
/

PROMPT Creating Table 'FND_CONCURRENT_QUEUES'
CREATE TABLE FND_CONCURRENT_QUEUES
 (APPLICATION_ID NUMBER(15,0) NOT NULL
 ,CONCURRENT_QUEUE_ID NUMBER(15,0) NOT NULL
 ,CONCURRENT_QUEUE_NAME VARCHAR2(30) NOT NULL
 ,LAST_UPDATE_DATE DATE NOT NULL
 ,LAST_UPDATED_BY NUMBER(15,0) NOT NULL
 ,CREATION_DATE DATE NOT NULL
 ,CREATED_BY NUMBER(15,0) NOT NULL
 ,LAST_UPDATE_LOGIN NUMBER(15,0) DEFAULT 0 NOT NULL
 ,PROCESSOR_APPLICATION_ID NUMBER(15,0) NOT NULL
 ,CONCURRENT_PROCESSOR_ID NUMBER(15,0) NOT NULL
 ,MAX_PROCESSES NUMBER(4,0) NOT NULL
 ,RUNNING_PROCESSES NUMBER(4,0) NOT NULL
 ,CACHE_SIZE NUMBER(3,0)
 ,MIN_PROCESSES NUMBER(4,0)
 ,TARGET_PROCESSES NUMBER(4,0)
 ,TARGET_NODE VARCHAR2(30)
 ,TARGET_QUEUE VARCHAR2(30)
 ,SLEEP_SECONDS NUMBER(4,0)
 ,CONTROL_CODE VARCHAR2(1)
 ,DIAGNOSTIC_LEVEL VARCHAR2(1)
 ,MANAGER_TYPE VARCHAR2(30)
 ,NODE_NAME VARCHAR2(30)
 ,NODE_NAME2 VARCHAR2(30)
 ,OS_QUEUE VARCHAR2(30)
 ,OS_QUEUE2 VARCHAR2(30)
 ,DATA_GROUP_ID NUMBER(15)
 ,RESTART_TYPE VARCHAR2(1)
 ,RESTART_INTERVAL NUMBER(15)
 ,ATTRIBUTE_CATEGORY VARCHAR2(30)
 ,ATTRIBUTE VARCHAR2(2000)
 ,ATTRIBUTE1 VARCHAR2(30)
 ,ATTRIBUTE2 VARCHAR2(30)
 ,ATTRIBUTE3 VARCHAR2(30)
 ,ATTRIBUTE4 VARCHAR2(30)
 ,ATTRIBUTE5 VARCHAR2(30)
 ,ATTRIBUTE6 VARCHAR2(30)
 ,ATTRIBUTE7 VARCHAR2(30)
 ,ATTRIBUTE8 VARCHAR2(30)
 ,ATTRIBUTE9 VARCHAR2(30)
 ,ATTRIBUTE10 VARCHAR2(30)
 ,ATTRIBUTE11 VARCHAR2(30)
 ,ATTRIBUTE12 VARCHAR2(30)
 ,ENABLED_FLAG VARCHAR2(1) DEFAULT 'Y' NOT NULL
 ,RESOURCE_CONSUMER_GROUP VARCHAR2(30)
 ,PMON_STAT NUMBER
 ,LAST_VERIFIED DATE
 ,WORK_START DATE
 ,WORK_END DATE
 ,PCP_FLAG VARCHAR2(1)
 ,INSTANCE_NUMBER NUMBER
 ,CONTEXT_BUFFER VARCHAR2(2000)
 ,SERVICE_PARAMETERS VARCHAR2(2000)
 ,TIME_PERIOD_ID NUMBER(15)
 ,TIME_PERIOD_APP_ID NUMBER(15)
 ,CONCURRENT_TIME_PERIOD_ID NUMBER(15)
 ,PERIOD_APPLICATION_ID NUMBER(15)
 )
/

PROMPT Creating Table 'FND_APPLICATION'
CREATE TABLE FND_APPLICATION
 (APPLICATION_ID NUMBER NOT NULL
 ,APPLICATION_SHORT_NAME VARCHAR2(50) NOT NULL
 ,CREATION_DATE DATE NOT NULL
 ,CREATED_BY NUMBER(15,0) NOT NULL
 ,LAST_UPDATE_DATE DATE NOT NULL
 ,LAST_UPDATED_BY NUMBER(15,0) NOT NULL
 ,LAST_UPDATE_LOGIN NUMBER(15,0) 
 ,BASEPATH VARCHAR2(20)
 )
/

-- M:\sacsharm\wfsvc.sqs
--
-- Generated for Oracle 8.1 on Tue Nov 19  12:59:14 2002 by Server Generator 6.5.82.2.0
 
PROMPT Creating Sequence 'FND_SVC_COMP_PARAMS_B_S'
CREATE SEQUENCE FND_SVC_COMP_PARAMS_B_S
 NOMAXVALUE
 NOMINVALUE
 NOCYCLE
 NOCACHE
/

PROMPT Creating Sequence 'FND_SVC_COMP_PARAM_VALS_S'
CREATE SEQUENCE FND_SVC_COMP_PARAM_VALS_S
 NOMAXVALUE
 NOMINVALUE
 NOCYCLE
 NOCACHE
/

PROMPT Creating Sequence 'FND_SVC_COMP_REQUESTS_H_S'
CREATE SEQUENCE FND_SVC_COMP_REQUESTS_H_S
 NOMAXVALUE
 NOMINVALUE
 NOCYCLE
 NOCACHE
/

PROMPT Creating Sequence 'FND_SVC_COMPONENTS_S'
CREATE SEQUENCE FND_SVC_COMPONENTS_S
 NOMAXVALUE
 NOMINVALUE
 NOCYCLE
 NOCACHE
/

PROMPT Creating Sequence 'FND_SVC_COMP_REQUESTS_S'
CREATE SEQUENCE FND_SVC_COMP_REQUESTS_S
 NOMAXVALUE
 NOMINVALUE
 NOCYCLE
 NOCACHE
/

PROMPT Creating Sequence 'FND_SVC_CONTAINERS_S'
CREATE SEQUENCE FND_SVC_CONTAINERS_S
 NOMAXVALUE
 NOMINVALUE
 NOCYCLE
 NOCACHE
/

commit;
exit;
