REM $Header: afsvcd.sql 26.3 2003/02/05 03:26:31 sacsharm ship $
REM +======================================================================+
REM | Copyright (c) 2000 Oracle Corporation Redwood Shores, California, USA|
REM |                       All rights reserved.                           |
REM +======================================================================+
REM
REM NAME
REM   afsvcd.sql - Generic Service Components Drop objects script
REM DESCRIPTION
REM   Drops all data model objects associated with the GSC
REM USAGE
REM   sqlplus apps/apps @afsvcd applsys fnd
REM   sqlplus apps/apps @afsvcd apps apps
REM +======================================================================+

REM Connect to base account
REM (autopatch will run all scripts in apps account)
connect &1/&2;

REM Continue in case of error where objects may not exist
WHENEVER SQLERROR CONTINUE;

-- Drop packages

drop package FND_SVC_COMP_REQUESTS_H_PKG ;
drop package FND_SVC_COMPONENTS_PKG ;
drop package FND_SVC_COMP_PARAMS_PKG ; 
drop package FND_SVC_COMP_REQUESTS_PKG ;
drop package FND_SVC_COMP_TYPES_PKG ; 
drop package FND_SVC_COMP_PARAM_VALS_PKG ;
drop package FND_SVC_COMPONENT ; 

-- Drop views

drop view FND_SVC_COMP_TYPES_VL ; 
drop view FND_SVC_COMP_PARAMS_VL ; 
drop view FND_SVC_COMP_TYPE_EVENTS_V;
drop view FND_SVC_COMP_REQUESTS_H_V;
drop view FND_SVC_COMP_PARAM_VALS_V;
drop view FND_SVC_COMPONENTS_V;
drop view FND_SVC_COMP_REQUESTS_V;
drop view FND_CONCURRENT_QUEUES_VL;

-- Drop tables

drop TABLE FND_SVC_COMP_REQUESTS_H;
drop TABLE FND_SVC_COMP_REQUESTS;
drop TABLE FND_SVC_COMP_PARAM_VALS;
drop TABLE FND_SVC_COMPONENTS;
drop TABLE FND_SVC_COMP_PARAMS_TL;
drop TABLE FND_SVC_COMP_PARAMS_B;
drop TABLE FND_SVC_COMP_TYPES_TL;
drop TABLE FND_SVC_COMP_TYPES_B;
drop TABLE FND_CONCURRENT_QUEUES_TL;
drop TABLE FND_CONCURRENT_QUEUES;
drop TABLE FND_APPLICATION;

-- Drop sequences 

drop SEQUENCE FND_SVC_COMP_PARAMS_B_S;
drop SEQUENCE FND_SVC_COMP_PARAM_VALS_S;
drop SEQUENCE FND_SVC_COMP_REQUESTS_H_S;
drop SEQUENCE FND_SVC_COMPONENTS_S;
drop SEQUENCE FND_SVC_COMP_REQUESTS_S;
drop SEQUENCE FND_SVC_CONTAINERS_S;

commit;
exit;
