REM $Header: afsvcdat.sql 26.3 2004/05/14 01:05:10 yohuang ship $
REM +======================================================================+
REM | Copyright (c) 2002 Oracle Corporation Redwood Shores, California, USA|
REM |                       All rights reserved.                           |
REM +======================================================================+
REM   NAME
REM       afsvcdat.sql - Generic Service Components Seed Data Script
REM   DESCRIPTION
REM       Load seed data for Generic Service Components Framework
REM   USAGE
REM       sqlplus apps/apps @afsvcdat.sql
REM   NOTES
REM       This script populates columns in:
REM         FND_SVC_COMP_TYPES_B
REM         FND_SVC_COMP_TYPES_TL
REM         FND_SVC_COMP_PARAMS_B
REM         FND_SVC_COMP_PARAMS_TL
REM         FND_SVC_COMPONENTS
REM         FND_SVC_COMP_PARAM_VALS
REM
--
REM   dbdrv: none
--

WHENEVER SQLERROR EXIT FAILURE ROLLBACK

DECLARE
BEGIN
    WF_EVENTS_PKG.LOADERSETMODE
    (
        X_MODE => 'UPGRADE'
    );
--
-- Component Types
--
FND_SVC_COMP_TYPES_PKG.LOAD_ROW
(
    X_COMPONENT_TYPE => 'BASE'
  , X_COMPONENT_CLASS_NAME => 'oracle.apps.fnd.cp.gsc.SvcComponent'
  , X_CONFIG_UI_REGION => 'NONE'
  , X_CUSTOMIZATION_LEVEL => 'C'
  , X_DISPLAY_NAME => 'Base'
  , X_DESCRIPTION => 'This type is for internal display/use only.'
  , X_OBJECT_VERSION_NUMBER => -1
  , X_OWNER => 'ORACLE'
);

--
-- Component Parameter Definitions
--
FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
      X_PARAMETER_NAME => 'COMPONENT_LOG_LEVEL'             
    , X_COMPONENT_TYPE => 'BASE'
    , X_DEFAULT_PARAMETER_VALUE => '4'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'Y'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Log Level'
    , X_DESCRIPTION => 'Log level'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
      X_PARAMETER_NAME => 'PROCESSOR_MAX_ERROR_COUNT'             
    , X_COMPONENT_TYPE => 'BASE'
    , X_DEFAULT_PARAMETER_VALUE => '10'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'N'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Max Error Count'
    , X_DESCRIPTION => 'Maximum number of times processing fails before the Service Component stops with error'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
      X_PARAMETER_NAME => 'PROCESSOR_IN_THREAD_COUNT'             
    , X_COMPONENT_TYPE => 'BASE'
    , X_DEFAULT_PARAMETER_VALUE => '0'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'Y'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Inbound Thread Count'
    , X_DESCRIPTION => 'Number of inbound processing threads'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
      X_PARAMETER_NAME => 'PROCESSOR_OUT_THREAD_COUNT'             
    , X_COMPONENT_TYPE => 'BASE'
    , X_DEFAULT_PARAMETER_VALUE => '0'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'Y'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Outbound Thread Count'
    , X_DESCRIPTION => 'Number of outbound processing threads'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
      X_PARAMETER_NAME => 'PROCESSOR_LOOP_SLEEP'             
    , X_COMPONENT_TYPE => 'BASE'
    , X_DEFAULT_PARAMETER_VALUE => '5'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'N'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Processor Min Loop Sleep'
    , X_DESCRIPTION => 'Minimum amount of time in seconds the processing thread(s) will sleep when nothing has been read'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
      X_PARAMETER_NAME => 'PROCESSOR_MAX_LOOP_SLEEP'             
    , X_COMPONENT_TYPE => 'BASE'
    , X_DEFAULT_PARAMETER_VALUE => '60'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'N'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Processor Max Loop Sleep'
    , X_DESCRIPTION => 'Maximum amount of time in seconds the processing thread(s) will sleep when nothing has been read.  If this is set to 0, the back-off algorithm will not occur and Processor Min Loop Sleep will always be used'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
      X_PARAMETER_NAME => 'PROCESSOR_READ_TIMEOUT'             
    , X_COMPONENT_TYPE => 'BASE'
    , X_DEFAULT_PARAMETER_VALUE => '10'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'N'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Processor Read Wait Timeout'
    , X_DESCRIPTION => 'Amount of time in seconds the processing thread(s) will wait while reading on the outbound queue'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
      X_PARAMETER_NAME => 'PROCESSOR_ERROR_LOOP_SLEEP'             
    , X_COMPONENT_TYPE => 'BASE'
    , X_DEFAULT_PARAMETER_VALUE => '60'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'N'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Processor Error Loop Sleep'
    , X_DESCRIPTION => 'Amount of time in seconds the processing thread(s) will sleep after there has been an error'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

FND_SVC_COMP_PARAMS_PKG.LOAD_ROW 
(
      X_PARAMETER_NAME => 'PROCESSOR_READ_TIMEOUT_CLOSE'             
    , X_COMPONENT_TYPE => 'BASE'
    , X_DEFAULT_PARAMETER_VALUE => 'Y'
    , X_REQUIRED_FLAG => 'Y'
    , X_ALLOW_RELOAD_FLAG => 'N'
    , X_ENCRYPTED_FLAG => 'N'
    , X_CUSTOMIZATION_LEVEL => 'C'
    , X_DISPLAY_NAME => 'Processor Close on Read Timeout'
    , X_DESCRIPTION => 'Whether or not to close if nothing was read'
    , X_OBJECT_VERSION_NUMBER => -1
    , X_OWNER => 'ORACLE'
);

END;

/
commit;
exit;
