REM $Header: afsvcfkc.sql 26.0 2002/11/27 03:00:39 sacsharm ship $
REM ***********************************************************************
REM   NAME
REM       afsvcfkc.sql - GSC Primary,Unique and Foreign Key constraint Create
REM   DESCRIPTION
REM       Adds constraints to all GSC tables
REM   USAGE
REM       sqlplus apps/apps @afsvcfkc applsys fnd
REM ********************************************************************
REM Connect to base account
REM (autopatch will run all scripts in apps account)
connect &1/&2;

REM Continue in case of error where constraints aready exist
WHENEVER SQLERROR CONTINUE;

-- M:\sacsharm\wfsvc.con
--
-- Generated for Oracle 8.1 on Tue Nov 19  12:59:13 2002 by Server Generator 6.5.82.2.0
  
-- Manually Added

PROMPT Creating Primary Key on 'FND_SVC_COMP_PARAM_VALS'
ALTER TABLE FND_SVC_COMP_PARAM_VALS
 ADD (CONSTRAINT FND_SVC_COMP_PARAM_VALS_PK1 PRIMARY KEY 
  (COMPONENT_PARAMETER_ID))
/

-- Manually Added

PROMPT Creating Primary Key on 'FND_SVC_COMP_REQUESTS'
ALTER TABLE FND_SVC_COMP_REQUESTS
 ADD (CONSTRAINT FND_SVC_COMP_REQUESTS_PK1 PRIMARY KEY 
  (COMPONENT_REQUEST_ID))
/

PROMPT Creating Primary Key on 'FND_SVC_COMPONENTS'
ALTER TABLE FND_SVC_COMPONENTS
 ADD (CONSTRAINT FND_SVC_COMPONENTS_PK1 PRIMARY KEY 
  (COMPONENT_ID))
/

PROMPT Creating Primary Key on 'FND_SVC_COMP_PARAMS_TL'
ALTER TABLE FND_SVC_COMP_PARAMS_TL
 ADD (CONSTRAINT FND_SVC_COMP_PARAMS_TL_PK1 PRIMARY KEY 
  (PARAMETER_ID
  ,LANGUAGE))
/

PROMPT Creating Primary Key on 'FND_SVC_COMP_TYPES_B'
ALTER TABLE FND_SVC_COMP_TYPES_B
 ADD (CONSTRAINT FND_SVC_COMP_TYPES_B_PK1 PRIMARY KEY 
  (COMPONENT_TYPE))
/

PROMPT Creating Primary Key on 'FND_SVC_COMP_TYPES_TL'
ALTER TABLE FND_SVC_COMP_TYPES_TL
 ADD (CONSTRAINT FND_SVC_COMP_TYPES_TL_PK1 PRIMARY KEY 
  (COMPONENT_TYPE
  ,LANGUAGE))
/

PROMPT Creating Primary Key on 'FND_SVC_COMP_REQUESTS_H'
ALTER TABLE FND_SVC_COMP_REQUESTS_H
 ADD (CONSTRAINT FND_SVC_COMP_REQUESTS_H_PK1 PRIMARY KEY 
  (REQUEST_HISTORY_ID))
/

PROMPT Creating Primary Key on 'FND_SVC_COMP_PARAMS_B'
ALTER TABLE FND_SVC_COMP_PARAMS_B
 ADD (CONSTRAINT FND_SVC_COMP_PARAMS_B_PK1 PRIMARY KEY 
  (PARAMETER_ID))
/

/************* No FKs are created, only indexes are defined ******

PROMPT Creating Foreign Key on 'FND_SVC_COMPONENTS'
ALTER TABLE FND_SVC_COMPONENTS ADD (CONSTRAINT
 FND_SVC_COMPONENTS_FK1 FOREIGN KEY 
  (COMPONENT_TYPE) REFERENCES FND_SVC_COMP_TYPES_B
  (COMPONENT_TYPE))
/

PROMPT Creating Foreign Key on 'FND_SVC_COMP_PARAMS_TL'
ALTER TABLE FND_SVC_COMP_PARAMS_TL ADD (CONSTRAINT
 FND_SVC_COMP_PARAMS_TL_FK1 FOREIGN KEY 
  (PARAMETER_ID) REFERENCES FND_SVC_COMP_PARAMS_B
  (PARAMETER_ID))
/

PROMPT Creating Foreign Key on 'FND_SVC_COMP_TYPES_TL'
ALTER TABLE FND_SVC_COMP_TYPES_TL ADD (CONSTRAINT
 FND_SVC_COMP_TYPES_TL_FK1 FOREIGN KEY 
  (COMPONENT_TYPE) REFERENCES FND_SVC_COMP_TYPES_B
  (COMPONENT_TYPE))
/

PROMPT Creating Foreign Key on 'FND_SVC_COMP_PARAMS_B'
ALTER TABLE FND_SVC_COMP_PARAMS_B ADD (CONSTRAINT
 FND_SVC_COMP_PARAMS_B_FK1 FOREIGN KEY 
  (COMPONENT_TYPE) REFERENCES FND_SVC_COMP_TYPES_B
  (COMPONENT_TYPE))
/

*************************************************/

commit;
exit;

