REM $Header: afsvcfkd.sql 26.1 2004/06/02 16:34:28 viksingh noship $
REM ***********************************************************************
REM   NAME
REM       afsvcfkd.sql - GSC Primary Key/ Unique Key/Foreign Key constraint Drop
REM   DESCRIPTION
REM       Drops Constraints of all GSC tables
REM   USAGE
REM       sqlplus apps/apps @afsvcfkd applsys fnd
REM ********************************************************************

REM Connect to base account
REM (autopatch will run all scripts in apps account)

connect &1/&2;

REM Continue in case of error where constraints may not exist
REM ad_error_handling: add 942 1418 2443

WHENEVER SQLERROR CONTINUE;

/*
****************************************************************
   This is a list of errors you may expect during the drop
   constraints/index phase:
   Err# 02443: Cannot drop constraint  - nonexistent constraint
   YOU MAY IGNORE THIS ERROR because we simply want to drop all 
   constraints irrespective if they existed in the first place.

   Err# 01418: specified index does not exist 
   YOU MAY IGNORE THIS ERROR for similar reasons

   Err# 00942: table or view does not exist 
   Will occur during an upgrade to 2.0.3. Similarly, you may 
   ignore this error during the drop index/constraint phase

****************************************************************
*/

ALTER TABLE FND_SVC_COMP_PARAM_VALS DROP CONSTRAINT FND_SVC_COMP_PARAM_VALS_PK1;
ALTER TABLE FND_SVC_COMP_REQUESTS DROP CONSTRAINT FND_SVC_COMP_REQUESTS_PK1;

ALTER TABLE FND_SVC_COMPONENTS DROP CONSTRAINT FND_SVC_COMPONENTS_PK1;
ALTER TABLE FND_SVC_COMP_PARAMS_TL DROP CONSTRAINT FND_SVC_COMP_PARAMS_TL_PK1;
ALTER TABLE FND_SVC_COMP_TYPES_B DROP CONSTRAINT FND_SVC_COMP_TYPES_B_PK1;
ALTER TABLE FND_SVC_COMP_TYPES_TL DROP CONSTRAINT FND_SVC_COMP_TYPES_TL_PK1;
ALTER TABLE FND_SVC_COMP_REQUESTS_H DROP CONSTRAINT FND_SVC_COMP_REQUESTS_H_PK1;
ALTER TABLE FND_SVC_COMP_PARAMS_B DROP CONSTRAINT FND_SVC_COMP_PARAMS_B_PK1;

-- As only PKs are created, only PKs are dropped

--ALTER TABLE FND_SVC_COMPONENTS DROP CONSTRAINT FND_SVC_COMPONENTS_FK1;
--ALTER TABLE FND_SVC_COMP_PARAMS_TL DROP CONSTRAINT FND_SVC_COMP_PARAMS_TL_FK1;
--ALTER TABLE FND_SVC_COMP_TYPES_TL DROP CONSTRAINT FND_SVC_COMP_TYPES_TL_FK1;
--ALTER TABLE FND_SVC_COMP_PARAMS_B DROP CONSTRAINT FND_SVC_COMP_PARAMS_B_FK1;

commit;
exit;
 
