REM $Header: afwfdmc.sql 26.0 2000/07/05 23:37:27 kma ship $
REM +======================================================================+
REM | Copyright (c) 1995 Oracle Corporation Redwood Shores, California, USA|
REM |                       All rights reserved.                           |
REM +======================================================================+
REM
REM NAME
REM     afwfdmc.sql  -  FND WorkFlow Document Management table Creation script 
REM +======================================================================+
 
REM Connect to base account
REM (autopatch will run all scripts in apps account)
connect &1/&2;
 
REM Continue in case of error where tables aready exist
WHENEVER SQLERROR CONTINUE;
  
set escape '*'
set escape '\'
set array 1
set scan off

/*
** FND_DM_NODES
*/
create table FND_DM_NODES 
(
 NODE_ID		NUMBER		NOT NULL,
 NODE_NAME		VARCHAR2(80)	NOT NULL,
 PRODUCT_ID		NUMBER		NOT NULL,
 CONNECT_SYNTAX		VARCHAR2(240)	NOT NULL,
 NODE_DESCRIPTION       VARCHAR2(240)
);

/*
** FND_DM_PRODUCTS
*/
create table FND_DM_PRODUCTS
(
 PRODUCT_ID		NUMBER		NOT NULL,
 PRODUCT_NAME		VARCHAR2(80)	NOT NULL,
 VENDOR_NAME		VARCHAR2(80)	NOT NULL,
 VERSION		VARCHAR2(20)
);

/*
** FND_DM_FUNCTIONS
*/
create table FND_DM_FUNCTIONS
(
 FUNCTION_ID		     NUMBER		NOT NULL,
 FUNCTION_NAME		     VARCHAR2(80)	NOT NULL,
 SEQUENCE                    NUMBER,
 NEW_DOCUMENT_FUNCTION       VARCHAR2(1),
 EXISTING_DOCUMENT_FUNCTION  VARCHAR2(1),
 RESOURCE_NAME               VARCHAR2(30),
 ICON_NAME                   VARCHAR2(30)
);

/*
** FND_DM_FUNCTION_PARAMETERS
*/
create table FND_DM_FUNCTION_PARAMETERS
(
 PARAMETER_ID		NUMBER		NOT NULL,
 PARAMETER_NAME		VARCHAR2(80)	NOT NULL,
 FUNCTION_ID		NUMBER		NOT NULL
);

/*
** FND_DM_PRODUCT_FUNCTION_SYNTAX
*/
create table FND_DM_PRODUCT_FUNCTION_SYNTAX
(
 PRODUCT_FUNCTION_ID	     NUMBER		NOT NULL,
 PRODUCT_ID	     	     NUMBER		NOT NULL,
 FUNCTION_ID	     	     NUMBER		NOT NULL,
 FUNCTION_SYNTAX	     VARCHAR2(4000)	NOT NULL
);

/*
** FND_DM_PRODUCT_PARM_SYNTAX
*/
create table FND_DM_PRODUCT_PARM_SYNTAX
(
 PRODUCT_PARAMETER_ID        NUMBER             NOT NULL,
 PRODUCT_FUNCTION_ID	     NUMBER		NOT NULL,
 PARAMETER_ID	     	     NUMBER		NOT NULL,
 PARAMETER_SYNTAX	     VARCHAR2(240)	NOT NULL,
 FORMAT                      VARCHAR2(40)       
);

/*
** FND_USER_PREFERENCES
*/
create table FND_USER_PREFERENCES (
USER_NAME        VARCHAR2(30)       NOT NULL,
MODULE_NAME      VARCHAR2(30)       NOT NULL,
PREFERENCE_NAME  VARCHAR2(30)       NOT NULL,
PREFERENCE_VALUE VARCHAR2(240)     
);


commit;
exit;
