REM $Header: wf203new.sql 26.0 2000/07/05 23:41:28 kma ship $
REM +======================================================================+
REM | Copyright (c) 1997 Oracle Corporation Redwood Shores, California, USA|
REM |                       All rights reserved.                           |
REM +======================================================================+
REM NAME
REM     wf203new.sql
REM DESCRIPTION
REM   Upgrade Workflow 2.0.2 -> Workflow 2.0.3 data model.
REM NOTES
REM -must be run after wffkd.sql and wfidxd.sql to drop fk and indexes
REM -installs all new tables
REM -installs all new sequences
REM 
REM +======================================================================+

REM Connect to base account
REM (autopatch will run all scripts in apps account)
connect &1/&2;

WHENEVER SQLERROR CONTINUE;


/*
** Create new tables 
**/

--
-- WF_ROUTING_RULES
--   New table
prompt WF_ROUTING_RULES
create table WF_ROUTING_RULES (
  RULE_ID         number not null,
  ROLE            varchar2(30) not null,
  ACTION          varchar2(8) not null,
  BEGIN_DATE      date,
  END_DATE        date,
  MESSAGE_TYPE    varchar2(8),
  MESSAGE_NAME    varchar2(30),
  ACTION_ARGUMENT varchar2(2000),
  RULE_COMMENT    varchar2(2000)
);

create sequence WF_ROUTING_RULES_S;

commit;

--
-- WF_ROUTING_RULE_ATTRIBUTES
--
prompt WF_ROUTING_RULE_ATTRIBUTES
create table WF_ROUTING_RULE_ATTRIBUTES (
  RULE_ID      number not null,
  NAME         varchar2(30) not null,
  TYPE         varchar2(8) not null,
  TEXT_VALUE   varchar2(2000),
  NUMBER_VALUE number,
  DATE_VALUE   date
);

/*
** WF_LOCAL_LANGUAGES - local languages
*/
create table WF_LOCAL_LANGUAGES
(
    CODE           varchar2(4)  not null,
    DISPLAY_NAME   varchar2(80) not null,
    NLS_LANGUAGE   varchar2(30) not null,
    NLS_TERRITORY  varchar2(30) not null,
    NLS_CODESET    varchar2(30) not null,
    INSTALLED_FLAG varchar2(1)  not null
);

commit;
exit;









