REM $Header: wf250upg.sql 26.3 2001/02/20 20:40:31 dlam ship $
REM +======================================================================+
REM | Copyright (c) 1995 Oracle Corporation Redwood Shores, California, USA|
REM |                       All rights reserved.                           |
REM +======================================================================+
REM   NAME
REM       wf250upg.sql - WorkFlow 2.5.0 Upgrade Script
REM   DESCRIPTION
REM       Upgrade Workflow 2.0.3 -> Workflow 2.5.0 data model.
REM   USAGE
REM       sqlplus apps/apps @wf250upg applsys fnd
REM   NOTES
REM   ###  Don't think this applies
REM   ###- This script must be run after wffkd.sql and wfidxd.sql to drop
REM   ###  fk and indexes.
REM   - Add new columns for Ad Hoc roles to tables:
REM		WF_LOCAL_USER_ROLES
REM		WF_LOCAL_ROLES
REM		WF_LOCAL_USERS
REM   - Add new sequence for Ad Hoc roles:
REM		WF_ADHOC_ROLE_S
REM   - Add new column for Error Item Type Support to table:
REM		WF_ACTIVITIES
REM   - Add new columns for Builder UI and others
REM		WF_ACTIVITIES
REM		WF_ITEM_ACTIVITY_STATUSES
REM		WF_ITEM_ACTIVITY_STATUSES_H
REM		WF_ITEM_TYPES
REM   - Add new view
REM		WF_WORKLIST_V
REM   - Modify view
REM		WF_ACTIVITIES_VL
REM		WF_ITEM_ACTIVITY_STATUSES_V
REM		WF_ITEM_TYPES_VL
REM   - Extend varchar2(2000) to 4000
REM             WF_ACTTRIBUTES
REM             WF_ACTIVITY_ATTR_VALUES
REM             WF_ITEM_ATTRIBUTES
REM             WF_ITEM_ATTRIBUTE_VALUES
REM             WF_MESSAGE_ATTRIBUTES
REM             WF_NOTIFICATION_ATTRIBUTES
REM             WF_ITEM_ACTIVITY_STATUSES
REM             WF_ITEM_ACTIVITY_STATUSES_H
REM             WF_MESSAGES_TL
REM             WF_NOTIFICATIONS
REM             WF_ROUTING_RULES
REM +======================================================================+

REM Connect to base account
REM (autopatch will run all scripts in apps account)
connect &1/&2;

REM Continue if errors so that script is re-runnable
WHENEVER SQLERROR CONTINUE

DEFINE hdr = "$Header: wf250upg.sql 26.3 2001/02/20 20:40:31 dlam ship $"

--
-- Alter Tables
--
alter table WF_LOCAL_USER_ROLES add
(
    USER_ORIG_SYSTEM     varchar2(30) default 'WF_LOCAL_USERS',
    USER_ORIG_SYSTEM_ID  number       default 0,
    ROLE_ORIG_SYSTEM     varchar2(30) default 'WF_LOCAL_ROLES',
    ROLE_ORIG_SYSTEM_ID  number       default 0
);

alter table WF_LOCAL_USERS add
(
    EXPIRATION_DATE      date
);

alter table WF_LOCAL_ROLES add
(
    EXPIRATION_DATE      date
);

--
-- Create Sequence
--
create sequence WF_ADHOC_ROLE_S;

--
-- Builder UI, Error Item Type Support and others
--
alter table WF_ACTIVITIES add
(
    RUNNABLE_FLAG      varchar2(1) default 'Y' not null,
    ERROR_ITEM_TYPE    varchar2(8) default 'WFERROR' not null,
    FUNCTION_TYPE      varchar2(30)
);

rem keep these seperate for the incremental releases
alter table WF_ITEM_ACTIVITY_STATUSES add
(
   outbound_queue_id  number
);
alter table WF_ITEM_ACTIVITY_STATUSES add
(
   due_date           date
);
alter Table WF_ITEM_ACTIVITY_STATUSES modify
(
    outbound_queue_id	raw(16)
);

rem keep these seperate for the incremental releases
alter table WF_ITEM_ACTIVITY_STATUSES_H add
(
   outbound_queue_id  number
);
alter table WF_ITEM_ACTIVITY_STATUSES_H add
(
   due_date           date
);
alter Table WF_ITEM_ACTIVITY_STATUSES_H modify
(
    outbound_queue_id	raw(16)
);



alter table WF_ITEM_TYPES add
(
   persistence_type   varchar2(8) default 'TEMP' not null,
   persistence_days   number      default 0
);

alter table WF_ACTIVITY_ATTRIBUTES modify
(
    text_default	varchar2(4000)
);

alter Table WF_ACTIVITY_ATTR_VALUES modify
(
    text_value		varchar2(4000)
);

alter Table WF_ITEM_ATTRIBUTES modify
(
    text_default	varchar2(4000)
);

alter Table WF_ITEM_ATTRIBUTE_VALUES modify
(
    text_value		varchar2(4000)
);

alter table WF_MESSAGE_ATTRIBUTES modify
(
   text_default	varchar2(4000)
);

alter table WF_NOTIFICATION_ATTRIBUTES modify
(
    text_value		varchar2(4000)
);

alter table WF_ITEM_ACTIVITY_STATUSES modify
(
    error_stack		varchar2(4000)
);

alter table WF_ITEM_ACTIVITY_STATUSES_H modify
(
    error_stack		varchar2(4000)
);

alter Table WF_MESSAGES_TL modify
(
    body		varchar2(4000)
);
alter Table WF_NOTIFICATIONS modify
(
    user_comment	varchar2(4000)
);
alter Table WF_ROUTING_RULES modify
(
    rule_comment	varchar2(4000)
);

REM Assume persistence_type already has 'not null' constraint
alter table WF_ITEM_TYPES modify
(
   persistence_type   varchar2(8) default 'TEMP',
   persistence_days   number      default 0
);

REM Mailer Related Changes
alter table WF_MESSAGES_TL add
(
   html_body          varchar2(4000)
);
alter table WF_MESSAGE_ATTRIBUTES add
(
   attach             varchar2(1)
);

REM Create new table for queue management.
create table WF_QUEUES 
(
   PROTOCOL             VARCHAR2(10),
   INBOUND_OUTBOUND	VARCHAR2(10),
   DESCRIPTION		VARCHAR2(240),
   QUEUE_COUNT		NUMBER,
   DISABLE_FLAG		VARCHAR2(1)
);

REM Denormalization of notification
alter table WF_NOTIFICATIONS add
(
   FROM_USER          varchar2(80),
   TO_USER            varchar2(80),
   SUBJECT            varchar2(2000),
   LANGUAGE           varchar2(4)
);


commit;
exit;
