REM $Header: wf260sed.sql 26.2 2004/06/09 09:50:12 rosthoma ship $
REM +======================================================================+
REM | Copyright (c) 1998 Oracle Corporation Redwood Shores, California, USA|
REM |                       All rights reserved.                           |
REM +======================================================================+
REM   NAME
REM       wf260sed.sql - WorkFlow 2.6.0 Seed data 
REM   NOTES
rem   this file MUST be run during upgrade to 2.6
rem   run it before 2.6 file are loaded into the databse
rem   It will copy the version of wfqueb.sql to a token 
rem   this is referenced later in wf260dat.sql
rem   based on this value the deferrd queue wil be rebuilt or not. 

rem HISTORY
rem   in 2.6, WF_DEFERRD_QUEUE will have schema tagged onto correlation 
rem   and will only process jobs for that schema. Therefore it must 
rem   drop and rebuilf the queue. 
rem   However, if users of 2.5 applied the backport patch of this, 
rem   then the queue will already have the schema tagged onto it. 
rem   In this scenario, we cannot drop the queue because it already 
rem   has the schema and we would loose that data if we do. 

WHENEVER SQLERROR EXIT FAILURE ROLLBACK

-- be aware of case where user may abort install. 


declare 
  q_version varchar2(200);
begin 
  begin
     select text
     into q_version
     from wf_resources 
     where name='WF_QUEUE_VERSION'
     and   language='US';
  exception 
  when no_data_found then 
    begin 
    insert into wf_resources(
     TYPE, NAME, LANGUAGE, SOURCE_LANG,	
     ID, TEXT, PROTECT_LEVEL, CUSTOM_LEVEL)
      select 
	'WFTKN', 'WF_QUEUE_VERSION', 'US','US',0,
	 substr(text,
	 instr(text,'wfqueb.pls')+11,
	 instr(text,' ',instr(text,'wfqueb.pls'),2)
	 -instr(text,'wfqueb.pls')-11) version,
	 0,0
      from all_source
      where name='WF_QUEUE'
      and text like '%$Header%'
      and owner = user 
      and type = 'PACKAGE BODY';
    end;
  end;
end;
/

commit;
exit;







