REM $Header: wf26achk.sql 26.0 2001/08/17 21:57:05 kma ship $
REM +======================================================================+
REM | Copyright (c) 1995 Oracle Corporation Redwood Shores, California, USA|
REM |                       All rights reserved.                           |
REM +======================================================================+
REM   NAME
REM       wf26achk.sql - WorkFlow Application Check Script
REM   DESCRIPTION
REM       Returns an error if the Embedded Workflow (i.e. Apps) is installed
REM   USAGE
REM       sqlplus apps/apps @wf26achk.sql 
REM +======================================================================+

WHENEVER SQLERROR EXIT FAILURE ROLLBACK;

select to_number('upgrade failed') from dual where exists
(select 'Embedded Workflow is installed'
 from wf_resources 
 where 
   text = 'EMBEDDED' 
   and name = 'WF_INSTALL'
   and type = 'WFTKN'
   and language = userenv('LANG') 
);

exit
