REM $Header: wf26vchk.sql 26.5 2004/05/13 09:47:55 rosthoma ship $
REM +======================================================================+
REM | Copyright (c) 1995 Oracle Corporation Redwood Shores, California, USA|
REM |                       All rights reserved.                           |
REM +======================================================================+
REM   NAME
REM       wf26vchk.sql - WorkFlow Version Check Script
REM   DESCRIPTION
REM       Returns an error if the Workflow version does not match 
REM       the specified one
REM   USAGE
REM       sqlplus apps/apps @wf26vchk.sql 
REM +======================================================================+

WHENEVER SQLERROR EXIT FAILURE ROLLBACK;

select to_number('upgrade failed') from dual where exists
(select 'Non Workflow 2.6.0, 2.6.1, or 2.6.2 is installed'
 from wf_resources 
 where 
 (ltrim(rtrim(text)) <> '2.6.0' and 
  ltrim(rtrim(text)) <> '2.6.1' and
  ltrim(rtrim(text)) <> '2.6.2' and
  ltrim(rtrim(text)) like '2.6.3.%')
 and language = 'US'
 and name = 'WF_VERSION');

exit
