REM dbdrv: sql ~PROD ~PATH ~FILE none none none package &phase=pls \
REM dbdrv: checkfile:~PROD:~PATH:~FILE
/*=======================================================================+
 |  Copyright (c) 1997 Oracle Corporation Redwood Shores, California, USA|
 |                            All rights reserved.                       |
 +=======================================================================+
 | FILENAME
 |  wfacts.sql
 | DESCRIPTION
 |   PL/SQL spec for package:  WF_ACTIVITIES_PKG
 *=======================================================================*/
SET VERIFY OFF;
WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR EXIT FAILURE ROLLBACK;

create or replace package WF_ACTIVITIES_PKG as
/* $Header: wfacts.pls 26.7 2002/12/03 00:29:35 dlam ship $ */
procedure INSERT_ROW (
  X_ROWID in out nocopy VARCHAR2,
  X_ITEM_TYPE in VARCHAR2,
  X_NAME in VARCHAR2,
  X_VERSION in NUMBER,
  X_TYPE in VARCHAR2,
  X_RERUN in VARCHAR2,
  X_EXPAND_ROLE in VARCHAR2,
  X_PROTECT_LEVEL in NUMBER,
  X_CUSTOM_LEVEL in NUMBER,
  X_BEGIN_DATE in DATE,
  X_END_DATE in DATE,
  X_FUNCTION in VARCHAR2,
  X_FUNCTION_TYPE in VARCHAR2,
  X_RESULT_TYPE in VARCHAR2,
  X_COST in NUMBER,
  X_READ_ROLE in VARCHAR2,
  X_WRITE_ROLE in VARCHAR2,
  X_EXECUTE_ROLE in VARCHAR2,
  X_ICON_NAME in VARCHAR2,
  X_MESSAGE in VARCHAR2,
  X_ERROR_PROCESS in VARCHAR2,
  X_DISPLAY_NAME in VARCHAR2,
  X_DESCRIPTION in VARCHAR2,
  X_ERROR_ITEM_TYPE in VARCHAR2,
  X_RUNNABLE_FLAG in VARCHAR2,
  X_EVENT_FILTER in VARCHAR2 default NULL,
  X_EVENT_TYPE in VARCHAR2 default NULL
);
procedure LOCK_ROW (
  X_ITEM_TYPE in VARCHAR2,
  X_NAME in VARCHAR2,
  X_VERSION in NUMBER,
  X_TYPE in VARCHAR2,
  X_RERUN in VARCHAR2,
  X_EXPAND_ROLE in VARCHAR2,
  X_PROTECT_LEVEL in NUMBER,
  X_CUSTOM_LEVEL in NUMBER,
  X_BEGIN_DATE in DATE,
  X_END_DATE in DATE,
  X_FUNCTION in VARCHAR2,
  X_RESULT_TYPE in VARCHAR2,
  X_COST in NUMBER,
  X_READ_ROLE in VARCHAR2,
  X_WRITE_ROLE in VARCHAR2,
  X_EXECUTE_ROLE in VARCHAR2,
  X_ICON_NAME in VARCHAR2,
  X_MESSAGE in VARCHAR2,
  X_ERROR_PROCESS in VARCHAR2,
  X_DISPLAY_NAME in VARCHAR2,
  X_DESCRIPTION in VARCHAR2
);
procedure UPDATE_ROW (
  X_ITEM_TYPE in VARCHAR2,
  X_NAME in VARCHAR2,
  X_VERSION in NUMBER,
  X_TYPE in VARCHAR2,
  X_RERUN in VARCHAR2,
  X_EXPAND_ROLE in VARCHAR2,
  X_PROTECT_LEVEL in NUMBER,
  X_CUSTOM_LEVEL in NUMBER,
  X_BEGIN_DATE in DATE,
  X_END_DATE in DATE,
  X_FUNCTION in VARCHAR2,
  X_RESULT_TYPE in VARCHAR2,
  X_COST in NUMBER,
  X_READ_ROLE in VARCHAR2,
  X_WRITE_ROLE in VARCHAR2,
  X_EXECUTE_ROLE in VARCHAR2,
  X_ICON_NAME in VARCHAR2,
  X_MESSAGE in VARCHAR2,
  X_ERROR_PROCESS in VARCHAR2,
  X_DISPLAY_NAME in VARCHAR2,
  X_DESCRIPTION in VARCHAR2
);
procedure DELETE_ROW (
  X_ITEM_TYPE in VARCHAR2,
  X_NAME in VARCHAR2,
  X_VERSION in NUMBER
);
procedure ADD_LANGUAGE;
end WF_ACTIVITIES_PKG;
/
-- show errors package WF_ACTIVITIES_PKG
commit;
exit;
