REM $Header: wfappsck.sql 26.5 2003/10/14 10:50:07 achitlan noship $
REM +======================================================================+
REM | Copyright (c) 2003 Oracle Corporation Redwood Shores, California, USA|
REM |                       All rights reserved.                           |
REM +======================================================================+
REM   NAME
REM       wfappsck.sql - WorkFlow Application Check Script
REM   DESCRIPTION
REM       Returns an error if the Embedded Workflow (i.e. Apps) is installed
REM       based on PER_PEOPLE_F object (view) from all_objects table.
REM   USAGE
REM       sqlplus apps/apps @wfappsck2.sql syspasswd
REM +======================================================================+

WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
connect sys/&1 as sysdba

declare
  l_check  varchar2(100);
begin
   --This query is costly , but in apps since we cannot
   --relay on schema names we do not have a choice of checking
   --the object_owner as this is a view created in user schema 
   --and not SYS/SYSTEM
   SELECT    'Embedded Workflow Installed'
   into      l_check 
   FROM      dual
   where     not exists 
            (SELECT    'Embedded Workflow Installed'
             FROM       all_objects
             where      object_name  = 'PER_PEOPLE_F'
             and        object_type  = 'VIEW');

exception
   when no_data_found then
       execute immediate 'create user owf_mgr identified by owf_mgr account lock';
       raise_application_error(-20000,'Oracle EBusiness Suite installation detected.  Workflow Standalone will not be installed in this Database'); 
   when others then
     raise;
end;
/
 
exit;


