REM $Header: wfcorec.sql 26.3 2002/09/25 14:55:59 varrajar ship $
REM +======================================================================+
REM | Copyright (c) 1995 Oracle Corporation Redwood Shores, California, USA|
REM |                       All rights reserved.                           |
REM +======================================================================+
REM NAME
REM     wfcorec.sql  -  WorkFlow CORE Create tables.
REM DESCRIPTION
REM     Core tables are shared by all other components of workflow.
REM MODIFICATION LOG:
REM     01/2002 JWSMITH BUG 2001012 - Increase read_role, write_role, 
REM             execute_role to varchar2(320)
REM     05/2002 VSHANMUG Bug 2353079 - Added new column SECURITY_GROUP_ID
REM             to all the tables 
REM	09/2002 VARRAJAR Modified SECURITY_GROUP_ID to be varchar2
REM +======================================================================+

REM Connect to base account
REM (autopatch will run all scripts in apps account)
connect &1/&2;

REM Continue in case of error where tables aready exist
WHENEVER SQLERROR CONTINUE;


/*
** WF_ITEM_TYPES
*/
create table WF_ITEM_TYPES
(
    NAME          varchar2(8)   not null,
    PROTECT_LEVEL number        default 1000 not null,
    CUSTOM_LEVEL  number        default 0 not null,
    PERSISTENCE_TYPE   varchar2(8) default 'TEMP' not null,
    PERSISTENCE_DAYS   number   default 0,
    WF_SELECTOR   varchar2(240),
    READ_ROLE     varchar2(320),
    WRITE_ROLE    varchar2(320),
    EXECUTE_ROLE  varchar2(320),
    SECURITY_GROUP_ID varchar2(32)
);

create table WF_ITEM_TYPES_TL
(
    NAME          varchar2(8)  not null,
    LANGUAGE      varchar2(4)  not null,
    DISPLAY_NAME  varchar2(80) not null,
    SOURCE_LANG   varchar2(4)  not null,
    PROTECT_LEVEL number       default 1000 not null,
    CUSTOM_LEVEL  number       default 0 not null,
    DESCRIPTION   varchar2(240),
    SECURITY_GROUP_ID varchar2(32)
);

/*
** WF_ITEM_ATTRIBUTES
*/
create table WF_ITEM_ATTRIBUTES
(
    ITEM_TYPE      varchar2(8)    not null,
    NAME           varchar2(30)   not null,
    SEQUENCE       number         not null,
    TYPE           varchar2(8)    not null,
    PROTECT_LEVEL  number         default 1000 not null,
    CUSTOM_LEVEL   number         default 0 not null,
    SUBTYPE        varchar2(8),
    FORMAT         varchar2(240),
    TEXT_DEFAULT   varchar2(4000),
    NUMBER_DEFAULT number,
    DATE_DEFAULT   date,
    SECURITY_GROUP_ID varchar2(32)
);

create table WF_ITEM_ATTRIBUTES_TL
(
    ITEM_TYPE     varchar2(8)   not null,
    NAME          varchar2(30)  not null,
    LANGUAGE      varchar2(4)   not null,
    DISPLAY_NAME  varchar2(80)  not null,
    SOURCE_LANG   varchar2(4)   not null,
    PROTECT_LEVEL number        default 1000 not null,
    CUSTOM_LEVEL  number        default 0 not null,
    DESCRIPTION   varchar2(240),
    SECURITY_GROUP_ID varchar2(32)
);

/*
** WF_LOOKUP_TYPES
*/
create table WF_LOOKUP_TYPES_TL
(
    LOOKUP_TYPE   varchar2(30) not null,
    DISPLAY_NAME  varchar2(80) not null,
    LANGUAGE      varchar2(4)  not null,
    ITEM_TYPE     varchar2(8)  not null,
    SOURCE_LANG   varchar2(4)  not null,
    PROTECT_LEVEL number       default 1000 not null,
    CUSTOM_LEVEL  number       default 0 not null,
    DESCRIPTION   varchar2(240),
    SECURITY_GROUP_ID varchar2(32)
);

/*
** WF_LOOKUPS
*/
create table WF_LOOKUPS_TL
(
    LOOKUP_TYPE   varchar2(30) not null,
    LOOKUP_CODE   varchar2(30) not null,
    MEANING       varchar2(80) not null,
    LANGUAGE      varchar2(4)  not null,
    SOURCE_LANG   varchar2(4)  not null,
    PROTECT_LEVEL number       default 1000 not null,
    CUSTOM_LEVEL  number       default 0 not null,
    DESCRIPTION   varchar2(240),
    SECURITY_GROUP_ID varchar2(32)
);

/*
** WF_RESOURCES
*/
create table WF_RESOURCES
(
    TYPE           varchar2(8)    not null,
    NAME           varchar2(30)   not null,
    LANGUAGE       varchar2(4)    not null,
    SOURCE_LANG    varchar2(4)    not null,
    ID             number         not null,
    TEXT           varchar2(2000) not null,
    PROTECT_LEVEL  number         default 1000 not null,
    CUSTOM_LEVEL   number         default 0 not null,
    SECURITY_GROUP_ID varchar2(32)
);

commit;
exit;
