REM $Header: wfcored.sql 26.0 2000/07/05 23:41:10 kma ship $
REM +======================================================================+
REM | Copyright (c) 1995 Oracle Corporation Redwood Shores, California, USA|
REM |                       All rights reserved.                           |
REM +======================================================================+
REM
REM NAME
REM   wfcored.sql - WorkFlow CORE Drop objects
REM DESCRIPTION
REM   Drops all objects associated with the CORE workflow component
REM USAGE
REM   sqlplus apps/apps @wfcored applsys fnd
REM   sqlplus apps/apps @wfcored apps apps
REM +======================================================================+

REM Connect to base account
REM (autopatch will run all scripts in apps account)
connect &1/&2;

REM Continue in case of error where objects may not exist
WHENEVER SQLERROR CONTINUE;

-- Drop packages
drop package  WF_RESOURCES_PKG;
drop package  WF_ITEM_TYPES_PKG;
drop package  WF_ITEM_ATTRIBUTES_PKG;
drop package  WF_LOOKUP_TYPES_PKG;
drop package  WF_LOOKUPS_PKG;
drop package  WF_CORE;
drop package  WFA_SEC;

-- Drop views
drop view     WF_ITEM_TYPES_VL;
drop view     WF_ITEM_ATTRIBUTES_VL;
drop view     WF_LOOKUP_TYPES;
drop view     WF_LOOKUPS;

-- Drop tables
drop table    WF_ITEM_TYPES;
drop table    WF_ITEM_TYPES_TL;
drop table    WF_ITEM_ATTRIBUTES;
drop table    WF_ITEM_ATTRIBUTES_TL;
drop table    WF_LOOKUP_TYPES_TL;
drop table    WF_LOOKUPS_TL;
drop table    WF_RESOURCES;

-- Drop synonyms
drop synonym  WF_RESOURCES_PKG;
drop synonym  WF_ITEM_TYPES_PKG;
drop synonym  WF_ITEM_ATTRIBUTES_PKG;
drop synonym  WF_LOOKUP_TYPES_PKG;
drop synonym  WF_LOOKUPS_PKG;
drop synonym  WF_CORE;
drop synonym  WFA_SEC;
drop synonym  WF_ITEM_TYPES_VL;
drop synonym  WF_ITEM_ATTRIBUTES_VL;
drop synonym  WF_LOOKUP_TYPES;
drop synonym  WF_LOOKUPS;
drop synonym  WF_ITEM_TYPES;
drop synonym  WF_ITEM_TYPES_TL;
drop synonym  WF_ITEM_ATTRIBUTES;
drop synonym  WF_ITEM_ATTRIBUTES_TL;
drop synonym  WF_LOOKUP_TYPES_TL;
drop synonym  WF_LOOKUPS_TL;
drop synonym  WF_RESOURCES;

commit;
exit;
