REM +======================================================================+
REM | Copyright (c) 1995 Oracle Corporation Redwood Shores, California, USA|
REM |                       All rights reserved.                           |
REM +======================================================================+
REM
REM NAME
REM     wfcorev.sql  -  create WorkFlow CORE Views.
REM +======================================================================+
REM Connect to base account
REM (autopatch will run all scripts in apps account)

DEFINE hdr = "$Header: wfcorev.sql 26.0 2000/07/05 23:42:38 kma ship $"

WHENEVER SQLERROR EXIT FAILURE ROLLBACK;

/*
** WF_ITEM_TYPES
*/
create or replace force view WF_ITEM_TYPES_VL ( 
    ROW_ID,
    NAME,
    PROTECT_LEVEL,
    CUSTOM_LEVEL,
    WF_SELECTOR,
    READ_ROLE,
    WRITE_ROLE,
    EXECUTE_ROLE,
    PERSISTENCE_TYPE,
    PERSISTENCE_DAYS,
    DISPLAY_NAME,
    DESCRIPTION
  ) as select /* $Header: wfcorev.sql 26.0 2000/07/05 23:42:38 kma ship $ */
    B.ROWID ROW_ID,
    B.NAME,
    B.PROTECT_LEVEL,
    B.CUSTOM_LEVEL,
    B.WF_SELECTOR,
    B.READ_ROLE,
    B.WRITE_ROLE,
    B.EXECUTE_ROLE,
    B.PERSISTENCE_TYPE,
    B.PERSISTENCE_DAYS,
    T.DISPLAY_NAME,
    T.DESCRIPTION
  from WF_ITEM_TYPES B, WF_ITEM_TYPES_TL T
  where B.NAME = T.NAME
  and T.LANGUAGE = userenv('LANG');

/*
** WF_ITEM_ATTRIBUTES
*/
create or replace force view WF_ITEM_ATTRIBUTES_VL ( 
    ROW_ID,
    ITEM_TYPE,
    NAME,
    SEQUENCE,
    TYPE,
    PROTECT_LEVEL,
    CUSTOM_LEVEL,
    SUBTYPE,
    FORMAT,
    TEXT_DEFAULT,
    NUMBER_DEFAULT,
    DATE_DEFAULT,
    DISPLAY_NAME,
    DESCRIPTION
  ) as select /* $Header: wfcorev.sql 26.0 2000/07/05 23:42:38 kma ship $ */
    B.ROWID ROW_ID,
    B.ITEM_TYPE,
    B.NAME,
    B.SEQUENCE,
    B.TYPE,
    B.PROTECT_LEVEL,
    B.CUSTOM_LEVEL,
    B.SUBTYPE,
    B.FORMAT,
    B.TEXT_DEFAULT,
    B.NUMBER_DEFAULT,
    B.DATE_DEFAULT,
    T.DISPLAY_NAME,
    T.DESCRIPTION
  from WF_ITEM_ATTRIBUTES B, WF_ITEM_ATTRIBUTES_TL T
  where B.ITEM_TYPE = T.ITEM_TYPE
  and B.NAME = T.NAME
  and T.LANGUAGE = userenv('LANG');


/*
** WF_LOOKUP_TYPES
*/
create or replace force view WF_LOOKUP_TYPES ( 
    ROW_ID,
    LOOKUP_TYPE,
    ITEM_TYPE,
    PROTECT_LEVEL,
    CUSTOM_LEVEL,
    DISPLAY_NAME,
    DESCRIPTION
  ) as select /* $Header: wfcorev.sql 26.0 2000/07/05 23:42:38 kma ship $ */
    B.ROWID ROW_ID,
    B.LOOKUP_TYPE,
    B.ITEM_TYPE,
    B.PROTECT_LEVEL,
    B.CUSTOM_LEVEL,
    B.DISPLAY_NAME,
    B.DESCRIPTION
  from WF_LOOKUP_TYPES_TL B
  where B.LANGUAGE = userenv('LANG');

/*
** WF_LOOKUPS
*/
create or replace force view WF_LOOKUPS ( 
    ROW_ID,
    LOOKUP_TYPE,
    LOOKUP_CODE,
    PROTECT_LEVEL,
    CUSTOM_LEVEL,
    MEANING,
    DESCRIPTION
  ) as select /* $Header: wfcorev.sql 26.0 2000/07/05 23:42:38 kma ship $ */
    B.ROWID ROW_ID,
    B.LOOKUP_TYPE,
    B.LOOKUP_CODE,
    B.PROTECT_LEVEL,
    B.CUSTOM_LEVEL,
    B.MEANING,
    B.DESCRIPTION
  from WF_LOOKUPS_TL B
  where B.LANGUAGE = userenv('LANG');

commit;
exit;
