REM dbdrv: sql ~PROD ~PATH ~FILE none none none sqlplus_single &phase=last \
REM dbdrv: checkfile:~PROD:~PATH:~FILE
REM $Header: wfctqcln.sql 26.3 2004/10/20 23:21:01 yohuang noship $
REM +=======================================================================+
REM |    Copyright (c) 2003 Oracle Corporation, Redwood Shores, CA, USA     |
REM |                         All rights reserved.                          |
REM +=======================================================================+
REM | FILENAME                                                              |
REM |   wfctqcln.sql - WorkFlow ConTrol Queue CLeaN                         |
REM |                                                                       |
REM | DESCRIPTION                                                           |
REM |   Submits a recurring DBMS Job for the Workflow Control Queue         | 
REM |   subscriber cleanup process to run every 6 hours.                    |
REM |                                                                       |
REM | USAGE                                                                 |
REM |   sqlplus <user/pwd>@<db> @wfctqcln.sql                               |
REM |                                                                       |
REM | HISTORY                                                               |
REM |   12-AUG-03 Vijay Shanmugam  Created.                                 |
REM +=======================================================================+

set verify off;
whenever sqlerror exit failure rollback;
whenever oserror exit failure rollback;

declare
  l_job   pls_integer;
  l_proc  varchar2(200);
begin

  l_proc := 'declare errbuf varchar2(4000); retcode varchar2(4000); ' ||
            'begin WF_BES_CLEANUP.CLEANUP_SUBSCRIBERS(errbuf, retcode); end;';

  begin
     select job into l_job
     from   user_jobs
     where  what like '%WF_BES_CLEANUP.CLEANUP_SUBSCRIBERS%';
  exception
     when no_data_found then
        l_job := null;
  end;
  
  -- No job submitted for Control Queue Cleanup, submit one to execute
  if (l_job is null) then
     dbms_job.Submit(l_job, l_proc, sysdate, 'sysdate + 4/24');
  else 
    -- Change the queue schedule to be executed every four hours
     dbms_job.Change(l_job, null, null, 'sysdate + 4/24');
  end if;

  -- If there is a job available, run it now
  -- if (l_job is not null) then
  --    dbms_job.Run(l_job); 
  -- end if;

end;
/
commit;
exit;
