REM *=======================================================================+
REM |  Copyright (c) 2001 Oracle Corporation Redwood Shores, California, USA|
REM |                            All rights reserved.                       |
REM +=======================================================================+
REM | FILENAME
REM |   wfctrole.sql 
REM | DESCRIPTION
REM |   Create a role wf__plsql_ui
REM +=======================================================================+
REM $Header: wfctrole.sql 26.1 2004/10/04 14:16:29 anachatt noship $

SET VERIFY OFF
WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR EXIT FAILURE ROLLBACK;

REM Add the continue when error for case when 
REM the role has already been created .

WHENEVER SQLERROR CONTINUE;
--CREATE ROLE wf_plsql_ui NOT IDENTIFIED;
DECLARE
	role_present varchar2(20);
BEGIN
	SELECT 'Exists' INTO role_present
	FROM SYS.DBA_ROLES
	WHERE ROLE = 'WF_PLSQL_UI';
	EXCEPTION
		WHEN NO_DATA_FOUND THEN
 		EXECUTE IMMEDIATE 'CREATE ROLE wf_plsql_ui NOT IDENTIFIED';
	
END;
/       

REM Grant admin privilege to this role in the current schema
REM The schema will be the owf_mgr

GRANT wf_plsql_ui TO &1 WITH ADMIN OPTION; 


exit;

