REM $Header: wfdbvck10.sql 26.2 2003/11/07 06:31:14 rosthoma noship $
REM +======================================================================+
REM | Copyright (c) 2003 Oracle Corporation Redwood Shores, California, USA|
REM |                       All rights reserved.                           |
REM +======================================================================+
REM   NAME
REM       wfdbvck10.sql - WorkFlow DataBase Version Check Script to 
REm                        check if its a 10i version.
REM   DESCRIPTION
REM       Returns an error if the Oracle10i database is connected 
REM       1 = sys username
REM       2 = sys password
REM   MODIFICATION
REM     28/04/03  ROSTHOMA   Created
REM   USAGE
REM       sqlplus apps/apps @wfdbvck10.sql <sys> <syspswd>
REM +======================================================================+

connect &1/&2 as sysdba;

WHENEVER SQLERROR EXIT FAILURE ROLLBACK;

select to_number('10g') from dual where exists
(select 'Oracle10i is installed'
 from v$version
 where banner like 'Oracle%10g%');

exit
