REM $Header: wfdigpol.sql 26.3 2003/09/09 03:38:47 mfisher noship $

REM dbdrv: sql ~PROD ~PATH ~FILE none none none sqlplus_single &phase=upa \
REM dbdrv: checkfile:~PROD:~PATH:~FILE &un_fnd &pw_fnd

REM /*=======================================================================+
REM  |     Copyright (c) 2002 Oracle Corporation Belmont, California, USA    |
REM  |                         All rights reserved.                          |
REM  +=======================================================================+
REM  |
REM  | NAME 
REM  |   wfdigspi.sql  
REM  |
REM  | DESCRIPTION
REM  |
REM  |  This script will populate the wf_signature_policies table
REM  |  with Policy/flavor information for the various supported policies.
REM  |
REM  |
REM  | HISTORY
REM  | 
REM  |   08/17/03   mfisher   -Created
REM  +=======================================================================*/


SET VERIFY OFF;
WHENEVER SQLERROR EXIT FAILURE ROLLBACK
WHENEVER OSERROR EXIT FAILURE ROLLBACK

REM insert the info if its not there yet 
insert into WF_SIGNATURE_POLICIES
   (SIG_POLICY, SIG_REQUIRED, FWK_SIG_FLAVOR,
    EMAIL_SIG_FLAVOR, RENDER_HINT, DEFAULT_POLICY)
  select 'DEFAULT', 'N', Null, Null, Null, 'Y'
    from dual
   where not exists
     (select 1 
        from WF_SIGNATURE_POLICIES
       where SIG_POLICY = 'DEFAULT');

insert into WF_SIGNATURE_POLICIES
   (SIG_POLICY, SIG_REQUIRED, FWK_SIG_FLAVOR,
    EMAIL_SIG_FLAVOR, RENDER_HINT, DEFAULT_POLICY)
  select 'PSIG_ONLY', 'Y', 'PSIG_FRAMEWORK', Null, 'BRIEF', 'N'
    from dual
   where not exists
     (select 1 
        from WF_SIGNATURE_POLICIES
       where SIG_POLICY = 'PSIG_ONLY');

insert into WF_SIGNATURE_POLICIES
   (SIG_POLICY, SIG_REQUIRED, FWK_SIG_FLAVOR,
    EMAIL_SIG_FLAVOR, RENDER_HINT, DEFAULT_POLICY)
  select 'PKCS7X509_ONLY', 'Y', 'PKCS7X509_FRAMEWORK', Null, 'BRIEF', 'N'
    from dual
   where not exists
     (select 1 
        from WF_SIGNATURE_POLICIES
       where SIG_POLICY = 'PKCS7X509_ONLY');

commit;
exit;

