REM $Header: wfdigspi.sql 26.3 2003/11/14 22:21:36 mfisher noship $

REM dbdrv: sql ~PROD ~PATH ~FILE none none none sqlplus_single &phase=upa \
REM dbdrv: checkfile:~PROD:~PATH:~FILE &un_fnd &pw_fnd

REM /*=======================================================================+
REM  |     Copyright (c) 2002 Oracle Corporation Belmont, California, USA    |
REM  |                         All rights reserved.                          |
REM  +=======================================================================+
REM  |
REM  | NAME 
REM  |   wfdigspi.sql  
REM  |
REM  | DESCRIPTION
REM  |
REM  |  This script will populate the wf_dig_SPI_FLAVORS table
REM  |  with SPI information for the various supported flavors of
REM  |  signatures.
REM  |
REM  |
REM  | HISTORY
REM  | 
REM  |   08/17/02   mfisher   -Created
REM  |   08/17/03   mfisher   -X509 updates
REM  +=======================================================================*/


SET VERIFY OFF;
WHENEVER SQLERROR EXIT FAILURE ROLLBACK
WHENEVER OSERROR EXIT FAILURE ROLLBACK

REM Get rid of old data.
delete from WF_DIG_SIG_SPI_FLAVORS
   where not exists
     (select 1
        from WF_DIG_SIG_SPI_FLAVORS
       where FLAVOR ='PKCS7X509_FRAMEWORK');

REM insert the info if its not there yet 
insert into  WF_DIG_SIG_SPI_FLAVORS
   (BSR_SPI, VERIFY_SPI, VALIDATE_SPI, CERT_MAPPER, BSR_FWK_CO, FLAVOR,
    VALIDATOR_STORE, VALIDATION_MODE, SIGNATURE_FORMAT, SIGNATURE_MODE)
  select 'oracle.apps.fnd.wf.DigitalSignature.SPI.PSIGBrowserSignRequestSPI',
	 'oracle.apps.fnd.wf.DigitalSignature.SPI.PSIGVerifierSPI',
	 'oracle.apps.fnd.wf.DigitalSignature.SPI.PSIGValidatorSPI',
	 'oracle.apps.fnd.wf.DigitalSignature.WFCertMapper',
         'oracle.apps.fnd.wf.DigitalSignature.SPI.PSIGFwkCO',
	 'PSIG_FRAMEWORK',
         NULL,
 	 'PSIG',
 	 'EXTERNAL',
 	 'FRAMEWORK'
    from dual
   where not exists
     (select 1 
        from WF_DIG_SIG_SPI_FLAVORS
       where FLAVOR ='PSIG_FRAMEWORK');

insert into  WF_DIG_SIG_SPI_FLAVORS
   (BSR_SPI, VERIFY_SPI, VALIDATE_SPI, CERT_MAPPER, BSR_FWK_CO, FLAVOR,
    VALIDATOR_STORE, VALIDATION_MODE, SIGNATURE_FORMAT, SIGNATURE_MODE)
  select 'oracle.apps.fnd.wf.DigitalSignature.SPI.X509BrowserSignRequestSPI',
	 null,
	 null,
	 'oracle.apps.fnd.wf.DigitalSignature.WFCertMapper',
         'oracle.apps.fnd.wf.DigitalSignature.SPI.X509FwkCO',
	 'PKCS7X509_FRAMEWORK',
         'oracle.apps.fnd.wf.DigitalSignature.SPI.X509CRLVStore',
 	 'CRL',
 	 'PKCS7',
 	 'FRAMEWORK'
    from dual
   where not exists
     (select 1 
        from WF_DIG_SIG_SPI_FLAVORS
       where FLAVOR ='PKCS7X509_FRAMEWORK');

commit;
exit;

