REM $Header: wfdird.sql 26.0 2000/07/05 23:42:21 kma ship $
REM +=======================================================================+
REM |  Copyright (c) 1995 Oracle Corporation Redwood Shores, California, USA|
REM |                            All rights reserved.                       |
REM +=======================================================================+
REM
REM NAME
REM   wfdird.sql - WorkFlow DIRectory Drop objects
REM DESCRIPTION
REM   Drops all objects associated with the Workflow Directory component
REM USAGE
REM   sqlplus apps/apps @wfdird applsys fnd
REM   sqlplus apps/apps @wfdird apps apps
REM +======================================================================+

REM Connect to base account
REM (autopatch will run all scripts in apps account)
connect &1/&2;

REM Continue in case of error where constraints may not exist
WHENEVER SQLERROR CONTINUE;

-- Drop packages
drop package  WF_DIRECTORY;

-- Drop views
drop view     WF_USER_ROLES;
drop view     WF_USERS;
drop view     WF_ROLES;
drop view     WF_LANGUAGES;

-- Drop Tables
drop table    WF_LOCAL_LANGUAGES;
drop table    WF_LOCAL_USERS;
drop table    WF_LOCAL_ROLES;
drop table    WF_LOCAL_USER_ROLES;

-- Drop Sequence
drop sequence WF_ADHOC_ROLE_S;

-- Drop synonyms
drop synonym  WF_DIRECTORY;
drop synonym  WF_USER_ROLES;
drop synonym  WF_USERS;
drop synonym  WF_ROLES;
drop synonym  WF_LANGUAGES;
drop synonym  WF_LOCAL_USERS;
drop synonym  WF_LOCAL_ROLES;
drop synonym  WF_LOCAL_USER_ROLES;

commit;
exit;
