REM $Header: wfecxd.sql 26.2 2004/12/09 20:01:37 dlam noship $
REM /*=======================================================================+
REM | Copyright @ 2004, 2004, Oracle.  All rights reserved.
REM +=======================================================================+
REM | FILENAME
REM |   wfecxd.sql
REM | DESCRIPTION
REM | This script drop    s all the ECX objects.
REM *=======================================================================*/
SET VERIFY OFF
WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR EXIT FAILURE ROLLBACK;
WHENEVER SQLERROR CONTINUE;

drop  INDEX ECX_ATTRIBUTE_MAPPINGS_U1;                                                                
drop  INDEX ECX_DOCLOGS_U1;                                                                           
drop  INDEX ECX_DOCLOGS_N1;                                                                           
drop  INDEX ECX_HUB_USERS_U2;                                                                         
drop  INDEX ECX_HUB_USERS_U1;                                                                         
drop  INDEX ECX_HUBS_U2;                                                                              
drop  INDEX ECX_HUBS_U1;                                                                              

drop  INDEX ECX_FILES_U1;                                                                             
drop  INDEX ECX_FILES_N1;                                                                             
drop  INDEX ECX_EXT_PROCESSES_U1;                                                                     
drop  INDEX ECX_EXT_PROCESSES_N1;                                                                     
drop  INDEX ECX_EXTERNAL_RETRY_U1;                                                                    
drop  INDEX ECX_TP_DETAILS_N2;                                                                        
drop  INDEX ECX_TP_DETAILS_N1;                                                                        
drop  INDEX ECX_STANDARD_ATTRIBUTES_U2;                                                               
drop  INDEX ECX_STANDARD_ATTRIBUTES_U1;                                                               
drop  INDEX ECX_STANDARDS_TL_U1;                                                                      
drop  INDEX ECX_STANDARDS_B_U2;                                                                       
drop  INDEX ECX_STANDARDS_B_U1;                                                                       
drop  INDEX ECX_PROC_MAPPINGS_U1;                                                                     

drop  INDEX ECX_OBJECT_LEVELS_U1;                                                                     
drop  INDEX ECX_OBJECT_ATTRIBUTES_U1;                                                                 
drop  INDEX ECX_OBJECT_ATTRIBUTES_N1;                                                                 
drop  INDEX ECX_OBJECTS_U1;                                                                           
drop  INDEX ECX_MSG_LOGS_U1;                                                                          
drop  INDEX ECX_MAPPINGS_U2;                                                                          
drop  INDEX ECX_MAPPINGS_U1;                                                                          
drop  INDEX ECX_LEVEL_MAPPINGS_U1;                                                                    
drop  INDEX ECX_INBOUND_LOGS_U1;                                                                      
drop  INDEX ECX_TRANSACTIONS_TL_U1;                                                                   
drop  INDEX ECX_TRANSACTIONS_B_U2;                                                                    
drop  INDEX ECX_TRANSACTIONS_B_U1;                                                                    
drop  INDEX ECX_TP_HEADERS_U2;                                                                        

drop  INDEX ECX_TP_HEADERS_U1;                                                                        
drop  INDEX ECX_TP_DETAILS_U2;                                                                        
drop  INDEX ECX_OXTA_LOGMSG_N2;                                                                       
drop  INDEX ECX_OXTA_LOGMSG_N1;                                                                       
drop  INDEX ECX_OUTBOUND_LOGS_U1;                                                                     
drop  INDEX ECX_XREF_STANDARDS_B_U1;                                                                  
drop INDEX ECX_XREF_HDR_TL_U1;                                                                       
drop  INDEX ECX_XREF_HDR_B_U2;                                                                        
drop  INDEX ECX_XREF_HDR_B_U1;                                                                        
drop  INDEX ECX_XREF_DTL_TL_U1;                                                                       
drop  INDEX ECX_XREF_DTL_B_U2;                                                                        
drop  INDEX ECX_XREF_DTL_B_U1;                                                                        
drop  INDEX ECX_XREF_DTL_B_N1;                                                                        

drop  INDEX ECX_TRAN_STAGE_DATA_U1;                                                                   
drop  INDEX ECX_XREF_STANDARDS_TL_U1;                                                                 
drop  INDEX ECX_XREF_STANDARDS_B_U3;                                                                  
drop  INDEX ECX_XREF_STANDARDS_B_U2;                                                                  
drop  INDEX ECX_EXTERNAL_LOGS_U1;                                                                     
drop  INDEX ECX_ERROR_MSGS_U1;                                                                        
drop  INDEX ECX_ECX_PROCESSES_U2;                                                                     
drop  INDEX ECX_DTDS_U2;                                                                              
drop  INDEX ECX_DTDS_U1;                                                                              
drop  PACKAGE ECX_ACTIONS;                                                                            
drop  PACKAGE ECX_CODE_CONVERSION_PVT;                                                                
drop  PACKAGE ECX_DEBUG;                                                                              
drop  PACKAGE ECX_TP_API;                                                                             

drop  PACKAGE ECX_STANDARDS_PKG;                                                                      
drop  PACKAGE ECX_STANDARD;                                                                           
drop  PACKAGE ECX_RULE;                                                                               
drop  PACKAGE ECX_PRINT_LOCAL;                                                                        
drop  PACKAGE ECX_OXTA_UTIL_PKG;                                                                      
drop  PACKAGE ECX_OXTA_PKG;                                                                           
drop  PACKAGE ECX_OUT_WF_QH;                                                                          
drop  PACKAGE ECX_OUTBOUND;                                                                           
drop  PACKAGE ECX_INBOUND_TRIG;                                                                       
drop  PACKAGE ECX_INBOUND_NEW;                                                                        
drop  PACKAGE ECX_INBOUND_LISTENER_QH;                                                                
drop  PACKAGE ECX_INBOUND_ENGINE_QH;                                                                  
drop  PACKAGE ECX_INBOUND;                                                                            

drop  PACKAGE ECX_XREF_DTL_PKG;                                                                       
drop  PACKAGE ECX_XREF_API;                                                                           
drop  PACKAGE ECX_WORKFLOW_HTML;                                                                      
drop  PACKAGE ECX_WF_ERRORS;                                                                          
drop  PACKAGE ECX_UTIL_API;                                                                           
drop  PACKAGE ECX_UTILS;                                                                              
drop  PACKAGE ECX_TRANSACTIONS_PKG;                                                                   
drop  PACKAGE ECX_TRANSACTIONS_API;                                                                   
drop  PACKAGE ECX_TRADING_PARTNER_PVT;                                                                
drop  PACKAGE ECX_XSLT_UTILS; 
         
drop PACKAGE ECX_ERRORLOG;                                                               
drop  PACKAGE ECX_XREF_STANDARDS_PKG;                                                                 
drop  PACKAGE ECX_XREF_HDR_PKG;                                                                       
drop  PACKAGE ECX_ERROR_HANDLING_PVT;                                                                 

drop  PACKAGE ECX_ENG_UTILS;                                                                          
drop  PACKAGE ECX_DTD_UTILS;                                                                          
drop  PACKAGE ECX_DOCUMENT_STANDARDS_API;                                                             
drop  PACKAGE ECX_DOCUMENT;                                                                           
drop  PACKAGE ECX_CONDITIONS;                                                                         
drop  PACKAGE ECX_ATTACHMENT;                                                                         
drop  PACKAGE BODY ECX_ACTIONS;                                                                       
drop  PACKAGE BODY ECX_OUTBOUND;                                                                      
drop  PACKAGE BODY ECX_INBOUND_TRIG;                                                                  
drop  PACKAGE BODY ECX_INBOUND_NEW;                                                                   
drop  PACKAGE BODY ECX_INBOUND_LISTENER_QH;                                                           
drop  PACKAGE BODY ECX_INBOUND_ENGINE_QH;                                                             
drop  PACKAGE BODY ECX_INBOUND;                                                                       
drop PACKAGE ECX_OBFUSCATE;

drop PACKAGE OXTA_ECX_PKG;

drop PACKAGE OXTA_UTIL_PKG;

drop  PACKAGE BODY ECX_ERROR_HANDLING_PVT;                                                            
drop  PACKAGE BODY ECX_ENG_UTILS;                                                                     
drop  PACKAGE BODY ECX_DTD_UTILS;                                                                     
drop  PACKAGE BODY ECX_XSLT_UTILS;                                                                    
drop  PACKAGE BODY ECX_XREF_STANDARDS_PKG;                                                            
drop  PACKAGE BODY ECX_XREF_HDR_PKG;                                                                  
drop  PACKAGE BODY ECX_XREF_DTL_PKG;                                                                  
drop  PACKAGE BODY ECX_XREF_API;                                                                      
drop  PACKAGE BODY ECX_WORKFLOW_HTML;                                                                 
drop  PACKAGE BODY ECX_WF_ERRORS;                                                                     
drop  PACKAGE BODY ECX_UTIL_API;                                                                      
drop  PACKAGE BODY ECX_UTILS;                                                                         
drop  PACKAGE BODY ECX_TRANSACTIONS_PKG;                                                              

drop  PACKAGE BODY ECX_TRANSACTIONS_API;                                                              
drop  PACKAGE BODY ECX_TRADING_PARTNER_PVT;                                                           
drop  PACKAGE BODY ECX_TP_API;                                                                        
drop  PACKAGE BODY ECX_STANDARDS_PKG;                                                                 
drop  PACKAGE BODY ECX_STANDARD;                                                                      
drop  PACKAGE BODY ECX_RULE;                                                                          
drop  PACKAGE BODY ECX_PRINT_LOCAL;                                                                   
drop  PACKAGE BODY ECX_OXTA_UTIL_PKG;                                                                 
drop  PACKAGE BODY ECX_OXTA_PKG;                                                                      
drop  PACKAGE BODY ECX_OUT_WF_QH;                                                                     
drop  PACKAGE BODY ECX_DOCUMENT_STANDARDS_API;                                                        
drop  PACKAGE BODY ECX_DOCUMENT;                                                                      
drop  PACKAGE BODY ECX_DEBUG;                                                                         

drop  PACKAGE BODY ECX_CONDITIONS;                                                                    
drop  PACKAGE BODY ECX_CODE_CONVERSION_PVT;                                                           
drop  PACKAGE BODY ECX_ATTACHMENT;

declare 
begin 
    dbms_aqadm.stop_queue(queue_name=>'ECX_OUTBOUND', 
                          wait=>FALSE); 
    dbms_aqadm.drop_queue(queue_name=>'ECX_OUTBOUND'); 
    dbms_aqadm.drop_queue_table(queue_table=>'ECX_OUTBOUND_TABLE', 
                                force=>TRUE); 
exception 
  when OTHERS then 
    null;  -- ignore any error 
end; 
/

declare 
begin 
    dbms_aqadm.stop_queue(queue_name=>'ECX_INBOUND', 
                          wait=>FALSE); 
    dbms_aqadm.drop_queue(queue_name=>'ECX_INBOUND'); 
    dbms_aqadm.drop_queue_table(queue_table=>'ECX_INBOUND_TABLE', 
                                force=>TRUE); 
exception 
  when OTHERS then 
    null;  -- ignore any error 
end; 
/

drop  SEQUENCE ECX_DTD_S;                                                                             
drop  SEQUENCE ECX_ERROR_NO_S;                                                                        
drop  SEQUENCE ECX_EXTERNAL_ID_S;                                                                     
drop  SEQUENCE ECX_FILES_S;                                                                           

drop  SEQUENCE ECX_INLSTN_S;                                                                          
drop  SEQUENCE ECX_TXNCOLS_S;                                                                         
drop  SEQUENCE ECX_TRIGGER_ID_S;                                                                      
drop  SEQUENCE ECX_TRANSACTIONS_S;                                                                    
drop  SEQUENCE ECX_TP_HEADERS_S;                                                                      
drop  SEQUENCE ECX_TP_DETAILS_S;                                                                      
drop  SEQUENCE ECX_STANDARD_ATTRIBUTES_S;                                                             
drop  SEQUENCE ECX_STANDARDS_S;                                                                       
drop  SEQUENCE ECX_REFERENCE_ID_S;                                                                    
drop  SEQUENCE ECX_OUTPUT_RUNS_S;                                                                     
drop  SEQUENCE ECX_MSG_LOGS_S;                                                                        
drop  SEQUENCE ECX_MAPPINGS_S;                                                                        
drop  SEQUENCE ECX_HUB_USERS_S;                                                                       

drop  SEQUENCE ECX_HUBS_S;                                                                            
drop  SEQUENCE ECX_XREF_STANDARDS_S;                                                                  
drop  SEQUENCE ECX_XREF_HDR_S;                                                                        
drop  SEQUENCE ECX_XREF_DTL_S;                                                                        
drop  SEQUENCE ECX_EXT_PROCESSES_S;                                                                   
drop  SYNONYM ECX_IN_PROCESS_V;                                                                       
drop  SYNONYM ECX_STANDARDS;                                                                          
drop  SYNONYM ECX_OUT_PROCESS_V;                                                                      
drop  SYNONYM ECX_XREF_STANDARDS;                                                                     
drop  SYNONYM ECX_XREF_HDR;                                                                           
drop  SYNONYM ECX_XREF_DTL;                                                                           
drop  SYNONYM ECX_TRANSACTIONS;                                                                       
REM
REM We are not touching ECX_INQUEUE_TABLE and ECX_OUTQUEUE_TABLE
REM because we do not believe they should exist now.
REM
declare 
begin 

    dbms_aqadm.stop_queue(queue_name=>'ECX_INQUEUE', 
                          wait=>FALSE); 
    dbms_aqadm.drop_queue(queue_name=>'ECX_INQUEUE'); 
    dbms_aqadm.drop_queue_table(queue_table=>'ECX_INQUEUE_TABLE', 
                                force=>TRUE); 
exception 
  when OTHERS then 
    null;  -- ignore any error 
end; 
/

declare 
begin 

    dbms_aqadm.stop_queue(queue_name=>'ECX_OUTQUEUE', 
                          wait=>FALSE); 
    dbms_aqadm.drop_queue(queue_name=>'ECX_OUTQUEUE'); 
    dbms_aqadm.drop_queue_table(queue_table=>'ECX_OUTQUEUE_TABLE', 
                                force=>TRUE); 
exception 
  when OTHERS then 
    null;  -- ignore any error 
end; 
/

begin 
    dbms_aqadm.stop_queue(queue_name=>'ECX_INBOUND', wait=>FALSE);
exception 
  when OTHERS then 
    null;  -- ignore any error 
end; 
/

begin 
    dbms_aqadm.drop_queue(queue_name=>'ECX_INBOUND'); 
exception 
  when OTHERS then 
    null;  -- ignore any error 
end; 
/

begin 
    dbms_aqadm.drop_queue_table(queue_table=>'ECX_INQUEUE', force=>TRUE);
exception 
  when OTHERS then 
    null;  -- ignore any error 
end; 
/

begin 
    dbms_aqadm.stop_queue(queue_name=>'ECX_OUTBOUND', wait=>FALSE);
exception 
  when OTHERS then 
    null;  -- ignore any error 
end; 
/

begin
    dbms_aqadm.drop_queue(queue_name=>'ECX_OUTBOUND');
exception 
  when OTHERS then 
    null;  -- ignore any error 
end; 
/

begin
    dbms_aqadm.drop_queue_table(queue_table=>'ECX_OUTQUEUE', force=>TRUE);
exception 
  when OTHERS then 
    null;  -- ignore any error 
end; 
/

declare 
begin 

    dbms_aqadm.stop_queue(queue_name=>'ECX_IN_OAG_Q', 
                          wait=>FALSE); 
    dbms_aqadm.drop_queue(queue_name=>'ECX_IN_OAG_Q'); 
    dbms_aqadm.drop_queue_table(queue_table=>'ECX_IN_OAG_Q_TABLE', 
                                force=>TRUE); 
exception 
  when OTHERS then 
    null;  -- ignore any error 
end; 
/

drop  VIEW ECX_DUMMY2_V;                                                                              
drop  VIEW ECX_OAG_CONTROLAREA_TP_V;                                                                  
drop  VIEW ECX_OUT_PROCESS_VL;                                                                        
drop  VIEW ECX_XREF_STANDARDS_VL;                                                                     
drop  VIEW ECX_XREF_HDR_VL;                                                                           
drop  VIEW ECX_XREF_HDR_MAPPED_V;                                                                     
drop  VIEW ECX_XREF_DTL_VL;                                                                           
drop  VIEW ECX_TRANSACTIONS_VL;                                                                       
drop  VIEW ECX_TP_DETAILS_V;                                                                          
drop  VIEW ECX_STANDARDS_VL;                                                                          
drop  VIEW ECX_OAG_CONTROLAREA_V;                                                                     
drop  VIEW ECX_OAG_CBOD_V;                                                                            
drop  VIEW ECX_MSGNAME_V;                                                                             
drop  VIEW ECX_IN_PROCESS_VL;               
drop  VIEW ECX_IN_PROCESS_V;
drop  VIEW ECX_OUT_PROCESS_V;                                                        
drop  VIEW ECX_HEADER_V;                                                                              
drop  VIEW ECX_DUMMY1_V;                                                                              

drop  TABLE ECX_INBOUND_LOGS;                                                                         
drop  TABLE ECX_HUB_USERS;                                                                            
drop  TABLE ECX_HUBS;                                                                                 
drop  TABLE ECX_FILES;                                                                                
drop  TABLE ECX_EXT_PROCESSES;                                                                        
drop  TABLE ECX_EXTERNAL_RETRY;                                                                       
drop  TABLE ECX_DTDS;                                                                                 
drop  TABLE ECX_ERROR_MSGS;                                                                           
drop  TABLE ECX_ATTACHMENT_MAPS;                                                                      
drop  TABLE ECX_DOCLOGS;                                                                              
drop  TABLE ECX_ATTRIBUTE_MAPPINGS;                                                                   
drop  TABLE ECX_EXTERNAL_LOGS;                                                                        
drop  TABLE ECX_XREF_STANDARDS_TL;                                                                    
drop  TABLE ECX_XREF_STANDARDS_B;                                                                     
drop  TABLE ECX_XREF_HDR_TL;                                                                          
drop  TABLE ECX_XREF_HDR_B;                                                                           
drop  TABLE ECX_XREF_DTL_TL;                                                                          
drop  TABLE ECX_XREF_DTL_B;                                                                           
drop  TABLE ECX_TRAN_STAGE_DATA;                                                                      
drop  TABLE ECX_TRANSACTIONS_TL;                                                                      
drop  TABLE ECX_TRANSACTIONS_B;                                                                       
drop  TABLE ECX_TP_HEADERS;                                                                           
drop  TABLE ECX_STANDARDS_TL;                                                                         
drop  TABLE ECX_STANDARDS_B;                                                                          
drop  TABLE ECX_PROC_MAPPINGS;                                                                        
drop  TABLE ECX_OXTA_LOGMSG;                                                                          
drop  TABLE ECX_OUTBOUND_LOGS;                                                                        
drop  TABLE ECX_OBJECT_LEVELS;                                                                        
drop  TABLE ECX_OBJECT_ATTRIBUTES;                                                                    
drop  TABLE ECX_OBJECTS;                                                                              
drop  TABLE ECX_MSG_LOGS;                                                                             
drop  TABLE ECX_MAPPINGS;                                                                             
drop  TABLE ECX_LEVEL_MAPPINGS;                                                                       
drop  TABLE ECX_TP_DETAILS;                                                                           
drop  TABLE ECX_STANDARD_ATTRIBUTES;                                                                  

drop  TYPE ECX_NODE_OBJ_TYPE FORCE;                                                                         
drop  TYPE ECX_NODE_TBL_TYPE FORCE;                                                                         
/
commit;
exit;



