REM $Header: wfengd.sql 26.0 2000/07/05 22:53:32 kma ship $
REM +=======================================================================+
REM |  Copyright (c) 1995 Oracle Corporation Redwood Shores, California, USA|
REM |                            All rights reserved.                       |
REM +=======================================================================+
REM
REM NAME
REM   wfengd.sql - WorkFlow ENGine Drop objects
REM DESCRIPTION
REM   Drops all objects associated with the Workflow Engine component
REM USAGE
REM   sqlplus apps/apps @wfengd applsys fnd
REM   sqlplus apps/apps @wfengd apps apps
REM +======================================================================+

REM Connect to base account
REM (autopatch will run all scripts in apps account)
connect &1/&2;

REM Continue in case of error where constraints may not exist
WHENEVER SQLERROR CONTINUE;

-- Drop packages
drop package  WF_ACTIVITY_ATTRIBUTES_PKG;
drop package  WF_ACTIVITIES_PKG;
drop package  WF_ITEM_ACTIVITY_STATUS;
drop package  WF_ITEM;
drop package  WF_PROCESS_ACTIVITY;
drop package  WF_ACTIVITY;
drop package  WF_ENGINE;
drop package  WF_LOAD;
drop package  WF_PURGE;
drop package  WF_REPORT;
drop package  WF_STANDARD;
drop package  WF_MONITOR;

-- Drop views
drop view     WF_ACTIVITIES_VL;
drop view     WF_ACTIVITY_ATTRIBUTES_VL;
drop view     WF_ITEM_ACTIVITY_STATUSES_V;

-- Drop tables
drop table    WF_ACTIVITIES;
drop table    WF_ACTIVITIES_TL;
drop table    WF_ACTIVITY_ATTRIBUTES;
drop table    WF_ACTIVITY_ATTRIBUTES_TL;
drop table    WF_ACTIVITY_ATTR_VALUES;
drop table    WF_ACTIVITY_TRANSITIONS;
drop table    WF_ITEMS;
drop table    WF_ITEM_ATTRIBUTE_VALUES;
drop table    WF_ITEM_ACTIVITY_STATUSES;
drop table    WF_ITEM_ACTIVITY_STATUSES_H;
drop table    WF_PROCESS_ACTIVITIES;

-- Drop sequences
drop sequence WF_PROCESS_ACTIVITIES_S;
drop sequence WF_ERROR_PROCESSES_S;

-- Drop synonyms
drop synonym  WF_ACTIVITY_ATTRIBUTES_PKG;
drop synonym  WF_ACTIVITIES_PKG;
drop synonym  WF_ITEM_ACTIVITY_STATUS;
drop synonym  WF_ITEM;
drop synonym  WF_PROCESS_ACTIVITY;
drop synonym  WF_ACTIVITY;
drop synonym  WF_ENGINE;
drop synonym  WF_LOAD;
drop synonym  WF_PURGE;
drop synonym  WF_REPORT;
drop synonym  WF_STANDARD;
drop synonym  WF_ACTIVITIES_VL;
drop synonym  WF_ACTIVITY_ATTRIBUTES_VL;
drop synonym  WF_ITEM_ACTIVITY_STATUSES_V;
drop synonym  WF_ACTIVITIES;
drop synonym  WF_ACTIVITIES_TL;
drop synonym  WF_ACTIVITY_ATTRIBUTES;
drop synonym  WF_ACTIVITY_ATTRIBUTES_TL;
drop synonym  WF_ACTIVITY_ATTR_VALUES;
drop synonym  WF_ACTIVITY_TRANSITIONS;
drop synonym  WF_ITEMS;
drop synonym  WF_ITEM_ATTRIBUTE_VALUES;
drop synonym  WF_ITEM_ACTIVITY_STATUSES;
drop synonym  WF_ITEM_ACTIVITY_STATUSES_H;
drop synonym  WF_PROCESS_ACTIVITIES;
drop synonym  WF_PROCESS_ACTIVITIES_S;
drop synonym  WF_ERROR_PROCESSES_S;

commit;
exit;
