REM $Header: wfentmc.sql 26.4 2004/05/26 01:33:01 kma ship $
REM +======================================================================+
REM | Copyright (c) 1995 Oracle Corporation Redwood Shores, California, USA|
REM |                       All rights reserved.                           |
REM +======================================================================+
REM NAME
REM     wfentmc.sql  -  WorkFlow Entity Mgr Create tables.
REM DESCRIPTION
REM     Table used by the entity mgr.
REM MODIFICATION LOG:
REM     07/04/02 J Cordes  Created
REM	09.25.02 Varrajar  Added column SECURITY_GROUP_ID
REM     11/19/02 J Cordes  Added WF_ENTITY_CHANGES table and seq
REM +======================================================================+

REM Connect to base account
REM (autopatch will run all scripts in apps account)
connect &1/&2;

REM Continue in case of error where tables aready exist
WHENEVER SQLERROR CONTINUE;

/*
** WF_ATTRIBUTE_CACHE
*/
create table wf_attribute_cache(
    ENTITY_TYPE         VARCHAR2(50)    NOT NULL,
    ENTITY_KEY_VALUE    VARCHAR2(256)   NOT NULL,
    ATTRIBUTE_NAME      VARCHAR2(256)   NOT NULL,
    ATTRIBUTE_VALUE     VARCHAR2(4000)  NOT NULL,
    LAST_UPDATE_DATE    DATE            NOT NULL,
    CHANGE_NUMBER       NUMBER,
    SECURITY_GROUP_ID   VARCHAR2(32) );

/*
** WF_ENTITY_CHANGES
*/
create table wf_entity_changes(
    ENTITY_TYPE       VARCHAR2(50)  NOT NULL, 
    ENTITY_KEY_VALUE  VARCHAR2(256) NOT NULL,
    FLAVOR            VARCHAR2(10)  NOT NULL, 
    CHANGE_DATE       DATE          NOT NULL,
    ENTITY_ID         NUMBER);                

/*
** Sequence WF_ENTITY_CHANGES_S
*/
create sequence WF_ENTITY_CHANGES_S;

commit;
exit;
