REM $Header: wfeventd.sql 26.2 2003/03/04 21:05:11 varrajar ship $
REM +======================================================================+
REM | Copyright (c) 2000 Oracle Corporation Redwood Shores, California, USA|
REM |                       All rights reserved.                           |
REM +======================================================================+
REM
REM NAME
REM   wfeventd.sql - WorkFlow EVENT Manager system Drop objects
REM DESCRIPTION
REM   Drops all data model objects associated with the Event Manager
REM USAGE
REM   sqlplus apps/apps @wfeventd applsys fnd
REM   sqlplus apps/apps @wfeventd apps apps
REM +======================================================================+

REM Connect to base account
REM (autopatch will run all scripts in apps account)
connect &1/&2;

REM Continue in case of error where objects may not exist
WHENEVER SQLERROR CONTINUE;

-- Drop packages
drop package  WF_EVENTS_PKG;
drop package  WF_EVENT_GROUPS_PKG;
drop package  WF_SYSTEMS_PKG;
drop package  WF_AGENTS_PKG;
drop package  WF_EVENT_SUBSCRIPTIONS_PKG;

-- Drop views
drop view     WF_EVENTS_VL;

-- Drop tables
drop table    WF_EVENTS;
drop table    WF_EVENTS_TL;
drop table    WF_EVENT_GROUPS;
drop table    WF_SYSTEMS;
drop table    WF_AGENTS;
drop table    WF_EVENT_SUBSCRIPTIONS;
drop table    WF_BES_SUBSCRIBER_PINGS;

-- Drop sequences
drop sequence WF_CONTROL_JMS_SUBSCRIBER_ID_S;
drop sequence WF_BES_PING_NUMBER_S;

commit;
exit;
