REM $Header: wffkd.sql 26.1 2002/08/19 18:41:27 varrajar ship $
REM ***********************************************************************
REM   NAME
REM       wffkd.sql - WorkFlow Primary Key/ Unique Key/Foreign Key constraint Drop
REM   DESCRIPTION
REM       Adds Constraints to all workflow tables
REM   USAGE
REM       sqlplus apps/apps @wffkc applsys fnd
REM ********************************************************************

REM Connect to base account
REM (autopatch will run all scripts in apps account)

connect &1/&2;

REM Continue in case of error where constraints may not exist
REM ad_error_handling: add 942 1418 2443

WHENEVER SQLERROR CONTINUE;

/*
****************************************************************
   This is a list of errors you may expect during the drop
   constraints/index phase:
   Err# 02443: Cannot drop constraint  - nonexistent constraint
   YOU MAY IGNORE THIS ERROR because we simply want to drop all 
   constraints irrespective if they existed in the first place.

   Err# 01418: specified index does not exist 
   YOU MAY IGNORE THIS ERROR for similar reasons

   Err# 00942: table or view does not exist 
   Will occur during an upgrade to 2.0.3. Similarly, you may 
   ignore this error during the drop index/constraint phase

****************************************************************
*/

/*
** Drop all foreign contraints with old naming standards
** If these have already been updated then you will get error
** Core foreign constraints (objects in wfcorec.sql)
*/

alter table WF_ITEM_ATTRIBUTES 
    drop constraint WF_ITEM_ATTRIBUTES_F1;
alter table WF_ITEM_ATTRIBUTES_TL 
    drop constraint WF_ITEM_ATTRIBUTES_TL_F1;
alter table WF_LOOKUP_TYPES_TL 
    drop constraint WF_LOOKUP_TYPES_TL_F1;
alter table WF_LOOKUPS_TL 
    drop constraint WF_LOOKUPS_TL_F1;

/*
** Notification foreign constraints (objects in wfntfc.sql)
*/

alter table WF_MESSAGES_TL 
    drop constraint WF_MESSAGES_TL_F1;
alter table WF_MESSAGE_ATTRIBUTES 
    drop constraint WF_MESSAGE_ATTRIBUTES_F1 ;
alter table WF_MESSAGE_ATTRIBUTES_TL 
    drop constraint WF_MESSAGE_ATTRIBUTES_TL_F1;
alter table WF_NOTIFICATIONS 
    drop constraint WF_NOTIFICATIONS_F1;
alter table WF_NOTIFICATION_ATTRIBUTES 
    drop constraint WF_NOTIFICATION_ATTR_F1;
alter table WF_ROUTING_RULE_ATTRIBUTES
  drop constraint WF_ROUTING_RULE_ATTRIBUTES_F1;


/*
** Engine foreign constraints (objects in wfengc.sql)
*/

alter table WF_ACTIVITIES 
    drop constraint WF_ACTIVITIES_F1;
alter table WF_ACTIVITIES 
    drop constraint WF_ACTIVITIES_F3;
alter table WF_ACTIVITY_ATTRIBUTES 
    drop constraint WF_ACTIVITY_ATTRIBUTES_F1;
alter table WF_ACTIVITY_ATTRIBUTES_TL 
    drop constraint WF_ACTIVITY_ATTRIBUTES_TL_F1;
alter table WF_PROCESS_ACTIVITIES 
    drop constraint WF_PROCESS_ACTIVITIES_F1;
alter table WF_ACTIVITY_ATTR_VALUES 
    drop constraint WF_ACTIVITY_ATTR_VALUES_F1;
alter table WF_ACTIVITY_TRANSITIONS 
    drop constraint WF_ACTIVITY_TRANSITIONS_F1;
alter table WF_ACTIVITY_TRANSITIONS 
    drop constraint WF_ACTIVITY_TRANSITIONS_F2;
alter table WF_ITEMS 
    drop constraint WF_ITEMS_F1;
alter table WF_ITEM_ATTRIBUTE_VALUES 
    drop constraint WF_ITEM_ATTRIBUTE_VALUES_F1;
alter table WF_ITEM_ACTIVITY_STATUSES 
    drop constraint WF_ITEM_ACTIVITY_STATUSES_F1;
alter table WF_ITEM_ACTIVITY_STATUSES 
    drop constraint WF_ITEM_ACTIVITY_STATUSES_F2;
alter table WF_ITEM_ACTIVITY_STATUSES 
    drop constraint WF_ITEM_ACTIVITY_STATUSES_F3;
alter table WF_ITEM_ACTIVITY_STATUSES_H 
    drop constraint WF_ITEM_ACTIVITY_STATUSES_H_F1;
alter table WF_ITEM_ACTIVITY_STATUSES_H 
    drop constraint WF_ITEM_ACTIVITY_STATUSES_H_F2;
alter table WF_ITEM_ACTIVITY_STATUSES_H 
    drop constraint WF_ITEM_ACTIVITY_STATUSES_H_F3;


/*
****************************************************************
** Drop all foreign contraints with new naming standards
** If these were never updated then they wont exist so you will 
** get the standard error 
****************************************************************
*/


rem    The following lines added since we are renaming the foreign key constraint 
rem    names to follow the standards.  The standard is to end the FK constraint
rem    name in _FK or _FK##  - Murali

/*
** Core foreign constraints (objects in wfcorec.sql)
*/

alter table WF_ITEM_ATTRIBUTES 
    drop constraint WF_ITEM_ATTRIBUTES_FK1;
alter table WF_ITEM_ATTRIBUTES_TL 
    drop constraint WF_ITEM_ATTRIBUTES_TL_FK1;
alter table WF_LOOKUP_TYPES_TL 
    drop constraint WF_LOOKUP_TYPES_TL_FK1;
alter table WF_LOOKUPS_TL 
    drop constraint WF_LOOKUPS_TL_FK1;

/*
** Notification foreign constraints (objects in wfntfc.sql)
*/

alter table WF_MESSAGES_TL 
    drop constraint WF_MESSAGES_TL_FK1;
alter table WF_MESSAGE_ATTRIBUTES 
    drop constraint WF_MESSAGE_ATTRIBUTES_FK1 ;
alter table WF_MESSAGE_ATTRIBUTES_TL 
    drop constraint WF_MESSAGE_ATTRIBUTES_TL_FK1;
alter table WF_NOTIFICATIONS 
    drop constraint WF_NOTIFICATIONS_FK1;
alter table WF_NOTIFICATION_ATTRIBUTES 
    drop constraint WF_NOTIFICATION_ATTR_FK1;
alter table WF_ROUTING_RULE_ATTRIBUTES
  drop constraint WF_ROUTING_RULE_ATTRIBUTES_FK1;


/*
** Engine foreign constraints (objects in wfengc.sql)
*/

alter table WF_ACTIVITIES 
    drop constraint WF_ACTIVITIES_FK1;
alter table WF_ACTIVITIES 
    drop constraint WF_ACTIVITIES_FK3;
alter table WF_ACTIVITY_ATTRIBUTES 
    drop constraint WF_ACTIVITY_ATTRIBUTES_FK1;
alter table WF_ACTIVITY_ATTRIBUTES_TL 
    drop constraint WF_ACTIVITY_ATTRIBUTES_TL_FK1;
alter table WF_PROCESS_ACTIVITIES 
    drop constraint WF_PROCESS_ACTIVITIES_FK1;
alter table WF_ACTIVITY_ATTR_VALUES 
    drop constraint WF_ACTIVITY_ATTR_VALUES_FK1;
alter table WF_ACTIVITY_TRANSITIONS 
    drop constraint WF_ACTIVITY_TRANSITIONS_FK1;
alter table WF_ACTIVITY_TRANSITIONS 
    drop constraint WF_ACTIVITY_TRANSITIONS_FK2;
alter table WF_ITEMS 
    drop constraint WF_ITEMS_FK1;
alter table WF_ITEM_ATTRIBUTE_VALUES 
    drop constraint WF_ITEM_ATTRIBUTE_VALUES_FK1;
alter table WF_ITEM_ACTIVITY_STATUSES 
    drop constraint WF_ITEM_ACTIVITY_STATUSES_FK1;
alter table WF_ITEM_ACTIVITY_STATUSES 
    drop constraint WF_ITEM_ACTIVITY_STATUSES_FK2;
alter table WF_ITEM_ACTIVITY_STATUSES 
    drop constraint WF_ITEM_ACTIVITY_STATUSES_FK3;
alter table WF_ITEM_ACTIVITY_STATUSES_H 
    drop constraint WF_ITEM_ACTIVITY_STATUS_H_FK1;
alter table WF_ITEM_ACTIVITY_STATUSES_H 
    drop constraint WF_ITEM_ACTIVITY_STATUS_H_FK2;
alter table WF_ITEM_ACTIVITY_STATUSES_H 
    drop constraint WF_ITEM_ACTIVITY_STATUS_H_FK3;

/*
** Start dropping all primary/unique constraints 
*/


/*
** Core primary/unique constraints (objects in wfcorec.sql)
*/

alter table WF_LOOKUP_TYPES_TL drop constraint WF_LOOKUP_TYPES_TL_PK;
alter table WF_LOOKUP_TYPES_TL drop constraint WF_LOOKUP_TYPES_TL_U2;
alter table WF_LOOKUPS_TL drop constraint WF_LOOKUPS_TL_PK;
alter table WF_LOOKUPS_TL drop constraint WF_LOOKUPS_TL_U2;
alter table WF_RESOURCES drop constraint WF_RESOURCES_PK;

/*
** Notification primary/unique constraints (objects in wfntfc.sql)
*/

alter table WF_MESSAGES drop constraint WF_MESSAGES_PK;
alter table WF_MESSAGES_TL drop constraint WF_MESSAGES_TL_PK;
alter table WF_MESSAGE_ATTRIBUTES drop constraint WF_MESSAGE_ATTRIBUTES_PK;
alter table WF_MESSAGE_ATTRIBUTES drop constraint WF_MESSAGE_ATTRIBUTES_U2;
alter table WF_MESSAGE_ATTRIBUTES_TL drop constraint WF_MESSAGE_ATTRIBUTES_TL_PK;
alter table WF_MESSAGE_ATTRIBUTES_TL drop constraint WF_MESSAGE_ATTRIBUTES_TL_U2;
alter table WF_NOTIFICATIONS drop constraint WF_NOTIFICATIONS_PK;
alter table WF_NOTIFICATION_ATTRIBUTES drop constraint WF_NOTIFICATIONS_ATTR_PK;
alter table WF_ROUTING_RULES 
  drop constraint WF_ROUTING_RULES_PK;
alter table WF_ROUTING_RULE_ATTRIBUTES 
  drop constraint WF_ROUTING_RULE_ATTRIBUTES_PK;

/*
** Engine primary/unique constraints (objects in wfengc.sql)
*/

alter table WF_ITEM_TYPES drop constraint WF_ITEM_TYPES_PK;
alter table WF_ITEM_TYPES_TL drop constraint WF_ITEM_TYPES_TL_PK;
alter table WF_ITEM_TYPES_TL drop constraint WF_ITEM_TYPES_TL_U2;
alter table WF_ITEM_ATTRIBUTES drop constraint WF_ITEM_ATTRIBUTES_PK;
alter table WF_ITEM_ATTRIBUTES drop constraint WF_ITEM_ATTRIBUTES_U2;
alter table WF_ITEM_ATTRIBUTES_TL drop constraint WF_ITEM_ATTRIBUTES_TL_PK;
alter table WF_ITEM_ATTRIBUTES_TL drop constraint WF_ITEM_ATTRIBUTES_TL_U2;
alter table WF_ACTIVITIES drop constraint WF_ACTIVITIES_PK;
alter table WF_ACTIVITIES_TL drop constraint WF_ACTIVITIES_TL_PK;
alter table WF_ACTIVITIES_TL drop constraint WF_ACTIVITIES_TL_U2;
alter table WF_ACTIVITY_ATTRIBUTES drop  constraint WF_ACTIVITY_ATTRIBUTES_PK;
alter table WF_ACTIVITY_ATTRIBUTES_TL drop constraint WF_ACTIVITY_ATTRIBUTES_TL_PK;
alter table WF_ACTIVITY_ATTRIBUTES_TL drop constraint WF_ACTIVITY_ATTRIBUTES_TL_U2;
alter table WF_PROCESS_ACTIVITIES drop constraint WF_PROCESS_ACTIVITIES_PK;
alter table WF_PROCESS_ACTIVITIES drop constraint WF_PROCESS_ACTIVITIES_U2;
alter table WF_ACTIVITY_ATTR_VALUES drop constraint WF_ACTIVITY_ATTR_VALUES_PK;
alter table WF_ACTIVITY_TRANSITIONS drop constraint WF_ACTIVITY_TRANSITIONS_PK;
alter table WF_ITEMS drop constraint WF_ITEMS_PK;
alter table WF_ITEM_ATTRIBUTE_VALUES drop constraint WF_ITEM_ATTRIBUTE_VALUES_PK;
alter table WF_ITEM_ACTIVITY_STATUSES drop constraint WF_ITEM_ACTIVITY_STATUSES_PK;

/*
** Local primary/unique directory constraints (Objects in wfdirc.sql)
*/
alter table WF_LOCAL_LANGUAGES drop constraint WF_LOCAL_LANGUAGES_PK;
alter table WF_LOCAL_LANGUAGES drop constraint WF_LOCAL_LANGUAGES_U1;
alter table WF_LOCAL_LANGUAGES drop constraint WF_LOCAL_LANGUAGES_U2;

alter table WF_LOCAL_USERS drop constraint WF_LOCAL_USERS_PK;
alter table WF_LOCAL_USERS drop constraint WF_LOCAL_USERS_U1;
alter table WF_LOCAL_USERS drop constraint WF_LOCAL_USERS_U2;
alter table WF_LOCAL_ROLES drop constraint WF_LOCAL_ROLES_PK;
alter table WF_LOCAL_ROLES drop constraint WF_LOCAL_ROLES_U1;
alter table WF_LOCAL_ROLES drop constraint WF_LOCAL_ROLES_U2;


commit;
exit;
 
