REM dbdrv: sql ~PROD ~PATH ~FILE none none none package &phase=plb \
REM dbdrv: checkfile:~PROD:~PATH:~FILE
/*=======================================================================*
 |  Copyright (C) 2002 Oracle Corporation Redwood Shores, California, USA|
 |                            All Rights Reserved.                       |
 +=======================================================================+
 | FILENAME                                                              |
 |   wffncalb.pls                                                        |
 | DESCRIPTION                                                           |
 |   PL/SQL body for package:  WF_FUNCTION_CALL                          |
 | MODIFICATION LOG                                                      |
 |                                                                       |
 *=======================================================================*/

SET VERIFY OFF;
WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR EXIT FAILURE ROLLBACK;

create or replace package body WF_FUNCTION_CALL as
/* $Header: wffncalb.pls 26.0 2002/10/11 05:54:20 vshanmug ship $ */

/*
** Execute - Makes a static call to the procedure based on the input
**           parameter funcname
*/

procedure Execute(funcname  in     varchar2, 
                  itemtype  in     varchar2,
                  itemkey   in     varchar2, 
                  actid     in     number,
                  funmode   in     varchar2,
                  resultout in out varchar2,
                  executed  out    boolean)
as
   l_funcname varchar2(240);
begin
   -- Stub out if no static calls to make. This procedure can be overwritten
   -- when required with the static calls
   executed := FALSE;

end Execute;

end WF_FUNCTION_CALL;
/
-- show errors package body WF_FUNCTION_CALL;
commit;
exit;
