REM dbdrv: sql ~PROD ~PATH ~FILE none none none package &phase=pls \
REM dbdrv: checkfile:~PROD:~PATH:~FILE
/*=======================================================================*
 |  Copyright (C) 2002 Oracle Corporation Redwood Shores, California, USA|
 |                            All Rights Reserved.                       |
 +=======================================================================+
 | FILENAME                                                              |
 |   wffncals.pls                                                        |
 | DESCRIPTION                                                           |
 |   PL/SQL specification for package:  WF_FUNCTION_CALL                 |
 | MODIFICATION LOG                                                      |
 |                                                                       |
 *=======================================================================*/

SET VERIFY OFF;
WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR EXIT FAILURE ROLLBACK;

create or replace package WF_FUNCTION_CALL as
/* $Header: wffncals.pls 26.1 2003/03/14 05:20:40 vshanmug ship $ */

/*
** Execute - Makes a static call to the procedure based on the input
**           parameter funcname
*/

procedure Execute(funcname  in     varchar2, 
                  itemtype  in     varchar2,
                  itemkey   in     varchar2, 
                  actid     in     number,
                  funmode   in     varchar2,
                  resultout in out nocopy varchar2,
                  executed  out    nocopy boolean);

end WF_FUNCTION_CALL;
/
-- show errors package WF_FUNCTION_CALL;
commit;
exit;
