REM dbdrv: sql ~PROD ~PATH ~FILE none none none package &phase=pls \
REM dbdrv: checkfile:~PROD:~PATH:~FILE
/*=======================================================================+
 |  Copyright (c) 1999 Oracle Corporation Redwood Shores, California, USA|
 |                            All rights reserved.                       |
 +=======================================================================+
 | FILENAME
 |   wffrms.pls
 | DESCRIPTION
 |   PL/SQL specification for package:  WF_FORMS
 *=======================================================================*/
set verify off
whenever sqlerror exit failure rollback;
WHENEVER OSERROR EXIT FAILURE ROLLBACK;

set scan off

create or replace package WF_FORMS as
/* $Header: wffrms.pls 26.6 2002/11/11 05:15:25 rosthoma ship $ */

java_loc   VARCHAR2(80) := '/OA_JAVA/';

--
-- Applet
--   Generate the applet tag for WFForms
-- IN
--   port - port listened by the socket listener
--   name - name for the applet
--   codebase - where the java classes can be located
--   archive  - first looks for java classes at this archive
--
-- OUT
--   status - true if is permitted to launch, false otherwise
--
procedure Applet(fname    in  varchar2,
                 dispname in  varchar2 default null,
                 port     in  varchar2 default '0',
                 codebase in  varchar2 default Wf_Forms.java_loc,
                 code     in  varchar2 default
                               'oracle.apps.fnd.wf.WFFormsApplet',
                 archive  in  varchar2 default null,
                 status   out boolean);

--
-- AppletWindow
--   Generate the applet window to call up a form
-- IN
--   fname - form function with format 'func1:PARAM1="&ID" PARAM2="&NAME"'
--   port - port listened by the socket listener
--   codebase - where the java classes can be located
--   code - name for the class
--   archive  - first looks for java classes at this archive
--
procedure AppletWindow(fname    in  varchar2,
                       port     in  varchar2 default '0',
                       codebase in  varchar2 default Wf_Forms.java_loc,
                       code     in  varchar2 default
                                    'oracle.apps.fnd.wf.WFFormsApplet',
                       archive  in  varchar2 default null);

end WF_FORMS;
/
commit;
exit;
