REM $Header: wfidxd.sql 26.13 2004/10/05 18:45:26 htay ship $
REM ***********************************************************************
REM   NAME
REM       wfidxd.sql - WorkFlow InDeX Drop
REM   DESCRIPTION
REM       Drops indexes on all workflow tables
REM   USAGE
REM       sqlplus apps/apps @wfidxd applsys fnd
REM ********************************************************************
REM Connect to base account
REM (autopatch will run all scripts in apps account)

REM   dbdrv: none

connect &1/&2;

REM Continue in case of error where index does not exist
WHENEVER SQLERROR CONTINUE;

/*
** Start dropping all indexes. 
** some of these indexes (or their bas table) may not exist 
** - do not be concerned 
*/

/*
** Core indices (objects in wfcorec.sql)
*/

drop index WF_ITEM_TYPES_PK;
drop index WF_ITEM_TYPES_TL_PK;
drop index WF_ITEM_TYPES_TL_U2;

drop index WF_ITEM_ATTRIBUTES_PK;
drop index WF_ITEM_ATTRIBUTES_U2;
drop index WF_ITEM_ATTRIBUTES_TL_PK;
drop index WF_ITEM_ATTRIBUTES_TL_U2;

drop index WF_LOOKUP_TYPES_TL_PK;
drop index WF_LOOKUP_TYPES_TL_U2;
drop index WF_LOOKUPS_TL_PK;
drop index WF_LOOKUPS_TL_U2;

drop index WF_RESOURCES_PK;


/*
** Notification indices (objects in wfntfc.sql)
*/

drop index WF_MESSAGES_PK;
drop index WF_MESSAGES_TL_PK;

drop index WF_MESSAGE_ATTRIBUTES_PK;
drop index WF_MESSAGE_ATTRIBUTES_U2;
drop index WF_MESSAGE_ATTRIBUTES_TL_PK;
drop index WF_MESSAGE_ATTRIBUTES_TL_U2;

drop index WF_NOTIFICATIONS_PK;
drop index WF_NOTIFICATIONS_N1;
drop index WF_NOTIFICATIONS_N2;
drop index WF_NOTIFICATIONS_N3;
drop index WF_NOTIFICATIONS_N4;
drop index WF_NOTIFICATIONS_N5;
drop index WF_NOTIFICATIONS_N6;
drop index WF_NOTIFICATIONS_N7;

drop index WF_NOTIFICATIONS_ATTR_PK;

drop index WF_ROUTING_RULES_PK;

drop index WF_ROUTING_RULE_ATTRIBUTES_PK;

/*
** Engine indices (objects in wfengc.sql)
*/

drop index WF_ACTIVITIES_PK;
drop index WF_ACTIVITIES_TL_PK;
drop index WF_ACTIVITIES_TL_U2;
drop index WF_ACTIVITIES_N1;

drop index WF_ACTIVITY_ATTRIBUTES_PK;
drop index WF_ACTIVITY_ATTRIBUTES_TL_PK;
drop index WF_ACTIVITY_ATTRIBUTES_TL_U2;

drop index WF_PROCESS_ACTIVITIES_PK;
drop index WF_PROCESS_ACTIVITIES_U2;
rem        in 2.0.2 this index was called N1 but in 203/21 we renamed it to N2
drop index WF_PROCESS_ACTIVITIES_N1;
drop index WF_PROCESS_ACTIVITIES_N2;


drop index WF_ACTIVITY_ATTR_VALUES_PK;

drop index WF_ACTIVITY_TRANSITIONS_PK;
drop index WF_ACTIVITY_TRANSITIONS_N1;

drop index WF_ITEMS_PK;
drop index WF_ITEMS_N1;
drop index WF_ITEMS_N2;
drop index WF_ITEMS_N3;
drop index WF_ITEMS_N4;
drop index WF_ITEMS_N5;
drop index WF_ITEMS_N6;
drop index WF_ITEMS_U1;

drop index WF_ITEM_ATTRIBUTE_VALUES_PK;

drop index WF_ITEM_ACTIVITY_STATUSES_PK;
drop index WF_ITEM_ACTIVITY_STATUSES_N1;
drop index WF_ITEM_ACTIVITY_STATUSES_N2;
drop index WF_ITEM_ACTIVITY_STATUSES_N3;
drop index WF_ITEM_ACTIVITY_STATUSES_N4;
drop index WF_ITEM_ACTIVITY_STATUSES_H_N1;
drop index WF_ITEM_ACTIVITY_STATUSES_H_N2;

drop index WF_QUEUES_U1;

/*
** Local directory indices (Objects in wfdirc.sql)
*/
drop index WF_LOCAL_LANGUAGES_PK;
drop index WF_LOCAL_LANGUAGES_U1;
drop index WF_LOCAL_LANGUAGES_U2;
drop index WF_LOCAL_LANGUAGES_N1;

drop index WF_LOCAL_USERS_PK;
drop index WF_LOCAL_USERS_U1;
drop index WF_LOCAL_USERS_U2;

drop index WF_LOCAL_ROLES_PK;
drop index WF_LOCAL_ROLES_U1;
drop index WF_LOCAL_ROLES_U2;
drop index WF_LOCAL_ROLES_N1;
drop index WF_LOCAL_ROLES_N2;
drop index WF_LOCAL_ROLES_N3;
drop index WF_LOCAL_ROLES_F1;
drop index WF_LOCAL_ROLES_TL_F1;

drop index WF_LOCAL_USER_ROLES_PK;
drop index WF_LOCAL_USER_ROLES_N1;
drop index WF_LOCAL_USER_ROLES_N2;
drop index WF_LOCAL_USER_ROLES_N3;
drop index WF_LOCAL_USER_ROLES_N4;
drop index WF_LOCAL_USER_ROLES_N5;
drop index WF_LOCAL_USER_ROLES_N6;
drop index WF_LOCAL_USER_ROLES_N7;
drop index WF_LOCAL_USER_ROLES_U1;

drop index WF_DIRECTORY_PARTITIONS_U1;

/*
** Event Indexes
*/
drop index WF_EVENTS_U1;
drop index WF_EVENTS_U2;
drop index WF_EVENTS_TL_U1;
drop index WF_EVENT_GROUPS_U1;
drop index WF_SYSTEMS_U1;
drop index WF_SYSTEMS_U2;
drop index WF_AGENTS_U1;
drop index WF_AGENTS_U2;
drop index WF_AGENTS_N1;
drop index WF_AGENT_GROUPS_U1;
drop index WF_EVENT_SUBSCRIPTIONS_U1;
drop index WF_EVENT_SUBSCRIPTIONS_N1;

drop index WF_BES_SUBSCRIBER_PINGS_U1;
drop index WF_BES_SUBSCRIBER_PINGS_N1;
drop index WF_BES_SUBSCRIBER_PINGS_N2;

/*
 * attribute cache index
 */
drop index WF_ATTRIBUTE_CACHE_U1;

commit;
exit;
