REM dbdrv: sql ~PROD ~PATH ~FILE none none none package &phase=pls \
REM dbdrv: checkfile:~PROD:~PATH:~FILE
/*=======================================================================+
 |  Copyright (c) 1998 Oracle Corporation Redwood Shores, California, USA|
 |                            All rights reserved.                       |
 +=======================================================================+
 | FILENAME
 |   wfinits.pls
 | DESCRIPTION
 |   PL/SQL body for package:  WF_INIT
 |   This creates a a web page from which to INITiate any workflow in 
 |   the database.
 | MODIFICATION LOG:
 |   01/2002 JWSMITH BUG 2001012 - Increased name_array to varchar2(320)
 *=======================================================================*/

SET VERIFY OFF
WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR EXIT FAILURE ROLLBACK;


create or replace package WF_INITIATE as
/* $Header: wfinits.pls 26.7 2002/11/11 05:34:48 rosthoma ship $ */

-- complex name#type identifiers from the web page
type name_array is table of varchar2(320) index by binary_integer;
-- values from the web page.
type value_array is table of varchar2(2000) index by binary_integer;


-- display all itemtypes in the database
procedure ItemType;

-- create input form for all data
-- required to run the process
procedure Process(
  ItemType in varchar2 default 'WFDEMO');

-- SubmitWorkflow
--   Submit the workflow
-- IN
procedure SubmitWorkflow(
  itemtype      in varchar2 default null,
  itemkey       in varchar2 default null,
  userkey       in varchar2 default null,
  process       in varchar2 default null,
  Owner  	in varchar2 default null,
  display_Owner in varchar2 default null,
  h_fnames      in Name_Array,
  h_fvalues     in Value_Array,
  h_fdocnames   in Value_Array,
  h_counter     in varchar2);



end WF_INITIATE;
/

commit;
exit; 
