REM dbdrv: sql ~PROD ~PATH ~FILE none none none package &phase=pls \
REM dbdrv: checkfile:~PROD:~PATH:~FILE
/*=======================================================================+
 |  Copyright (c) 1997 Oracle Corporation Redwood Shores, California, USA|
 |                            All rights reserved.                       |
 +=======================================================================+
 | FILENAME
 |   wfitts.sql
 | DESCRIPTION
 |   PL/SQL spec for package:  WF_ITEM_TYPES_PKG
 *=======================================================================*/
set verify off
whenever sqlerror exit failure rollback;
WHENEVER OSERROR EXIT FAILURE ROLLBACK;

create or replace package WF_ITEM_TYPES_PKG as
/* $Header: wfitts.pls 26.3 2002/11/11 05:42:52 rosthoma ship $ */
procedure INSERT_ROW (
  X_ROWID in out VARCHAR2,
  X_NAME in VARCHAR2,
  X_PROTECT_LEVEL in NUMBER,
  X_CUSTOM_LEVEL in NUMBER,
  X_WF_SELECTOR in VARCHAR2,
  X_READ_ROLE in VARCHAR2,
  X_WRITE_ROLE in VARCHAR2,
  X_EXECUTE_ROLE in VARCHAR2,
  X_DISPLAY_NAME in VARCHAR2,
  X_DESCRIPTION in VARCHAR2,
  X_PERSISTENCE_TYPE in VARCHAR2,
  X_PERSISTENCE_DAYS in NUMBER
);
procedure LOCK_ROW (
  X_NAME in VARCHAR2,
  X_PROTECT_LEVEL in NUMBER,
  X_CUSTOM_LEVEL in NUMBER,
  X_WF_SELECTOR in VARCHAR2,
  X_READ_ROLE in VARCHAR2,
  X_WRITE_ROLE in VARCHAR2,
  X_EXECUTE_ROLE in VARCHAR2,
  X_DISPLAY_NAME in VARCHAR2,
  X_DESCRIPTION in VARCHAR2
);
procedure UPDATE_ROW (
  X_NAME in VARCHAR2,
  X_PROTECT_LEVEL in NUMBER,
  X_CUSTOM_LEVEL in NUMBER,
  X_WF_SELECTOR in VARCHAR2,
  X_READ_ROLE in VARCHAR2,
  X_WRITE_ROLE in VARCHAR2,
  X_EXECUTE_ROLE in VARCHAR2,
  X_DISPLAY_NAME in VARCHAR2,
  X_DESCRIPTION in VARCHAR2,
  X_PERSISTENCE_TYPE in VARCHAR2,
  X_PERSISTENCE_DAYS in NUMBER
);
procedure DELETE_ROW (
  X_NAME in VARCHAR2
);
procedure ADD_LANGUAGE;
end WF_ITEM_TYPES_PKG;
/

commit;
exit;
