REM dbdrv: sql ~PROD ~PATH ~FILE none none none package &phase=plb \
REM dbdrv: checkfile:~PROD:~PATH:~FILE
/*=======================================================================+
 |  Copyright (c) 1995 Oracle Corporation Redwood Shores, California, USA|
 |                            All rights reserved.                       |
 +=======================================================================+
 | FILENAME
 |   wfjengb.pls
 | DESCRIPTION
 |   PL/SQL body for package:  WFJ_ENGINE
 *=======================================================================*/
set verify off;
whenever sqlerror exit failure rollback;
WHENEVER OSERROR EXIT FAILURE ROLLBACK;

create or replace package body WFJ_ENGINE as
/* $Header: wfjengb.pls 26.2 2002/11/06 13:34:37 rosthoma ship $ */

--
-- Error (PRIVATE)
--   Print a page with an error message.
--   Errors are retrieved from these sources in order:
--     1. wf_core errors
--     2. Oracle errors
--     3. Unspecified INTERNAL error
--
procedure Error
is
  error_name      varchar2(30) := '';
  error_message   varchar2(2000) := '';
  error_stack     varchar2(32000) := '';
begin

    wf_core.get_error(error_name, error_message, error_stack);
 
    if (error_name is not null) then
        htp.p('ErrorName is: '||error_name);
        htp.p('ErrorMessage is: '||error_message);
        htp.p('ErrorStack is: '||replace(error_stack,wf_core.newline,'<br>'));
    else
        htp.p('ErrorName is: '||wf_core.translate('WFSQL_ERROR'));
        htp.p('ErrorMessage is: '||sqlerrm);
        htp.p('ErrorStack is: '||sqlerrm);
    end if;
 
end Error;
 

procedure AddItemAttr(itemtype in varchar2,
                      itemkey in varchar2,
                      aname in varchar2) is

begin
    Wf_Engine.AddItemAttr(itemtype, itemkey, aname);
    htp.p('Success');
    return;
exception
    when others then
        Wfj_Engine.Error;
        return;
end AddItemAttr;
 

procedure SetItemAttrText(itemtype in varchar2,
                          itemkey in varchar2,
                          aname in varchar2,
                          avalue in varchar2) is
begin
    Wf_Engine.SetItemAttrText(itemtype, itemkey, aname, avalue);
    htp.p('Success');
    return;
exception
    when others then
        Wfj_Engine.Error;
        return;
end SetItemAttrText;
 

procedure SetItemAttrNumber(itemtype in varchar2,
                            itemkey in varchar2,
                            aname in varchar2,
                            avalue in number) is
begin
    Wf_Engine.SetItemAttrNumber(itemtype, itemkey, aname, avalue);
    htp.p('Success');
    return;
exception
    when others then
        Wfj_Engine.Error;
        return;
end SetItemAttrNumber;
 

procedure SetItemAttrDate(itemtype in varchar2,
                          itemkey in varchar2,
                          aname in varchar2,
                          avalue in date) is
begin
    Wf_Engine.SetItemAttrDate(itemtype, itemkey, aname, avalue);
    htp.p('Success');
    return;
exception
    when others then
        Wfj_Engine.Error;
        return;
end SetItemAttrDate;
 

procedure SetItemAttrDocument(itemtype in varchar2,
                              itemkey in varchar2,
                              aname in varchar2,
                              documentid in varchar2) is
begin
    Wf_Engine.SetItemAttrDocument(itemtype, itemkey, aname, documentid);
    htp.p('Success');
    return;
exception
    when others then
        Wfj_Engine.Error;
        return;
end SetItemAttrDocument;
 
procedure SetItemOwner(itemtype in varchar2,
                       itemkey in varchar2,
                       owner in varchar2) is
begin
    Wf_Engine.SetItemOwner(itemtype, itemkey, owner);
    htp.p('Success');
    return;
exception
    when others then
        Wfj_Engine.Error;
        return;
end SetItemOwner;
 

procedure SetItemUserKey(itemtype in varchar2,
                         itemkey in varchar2,
                         userkey In varchar2) is
begin
    Wf_Engine.SetItemUserKey(itemtype, itemkey, userkey);
    htp.p('Success');
    return;
exception
    when others then
        Wfj_Engine.Error;
        return;
end SetItemUserKey;
 

procedure CreateProcess(itemtype in varchar2,
                        itemkey  in varchar2,
                        process  in varchar2) is
begin
    Wf_Engine.CreateProcess(itemtype, itemkey, process);
    htp.p('Success');
    return;
exception
    when others then
        Wfj_Engine.Error;
        return;
end CreateProcess;
 

procedure StartProcess(itemtype in varchar2,
                       itemkey  in varchar2) is
begin
    Wf_Engine.StartProcess(itemtype, itemkey);
    htp.p('Success');
    return;
exception
    when others then
        Wfj_Engine.Error;
        return;
end StartProcess;
 


procedure SuspendProcess(itemtype in varchar2,
                         itemkey  in varchar2,
                         process  in varchar2) is
begin
    Wf_Engine.SuspendProcess(itemtype, itemkey, process);
    htp.p('Success');
    return;
exception
    when others then
        Wfj_Engine.Error;
        return;
end SuspendProcess;
 

procedure AbortProcess(itemtype in varchar2,
                       itemkey  in varchar2,
                       process  in varchar2,
                       result   in varchar2) is
begin
    Wf_Engine.AbortProcess(itemtype, itemkey, process, result);
    htp.p('Success');
    return;
exception
    when others then
        Wfj_Engine.Error;
        return;
end AbortProcess;
 

procedure ResumeProcess(itemtype in varchar2,
                        itemkey  in varchar2,
                        process  in varchar2) is
begin
    Wf_Engine.ResumeProcess(itemtype, itemkey, process);
    htp.p('Success');
    return;
exception
    when others then
        Wfj_Engine.Error;
        return;
end ResumeProcess;
 

procedure AssignActivity(itemtype in varchar2,
                         itemkey  in varchar2,
                         activity in varchar2,
                         performer in varchar2) is
begin
    Wf_Engine.AssignActivity(itemtype, itemkey, activity, performer);
    htp.p('Success');
    return;
exception
    when others then
        Wfj_Engine.Error;
        return;
end AssignActivity;
 

END WFJ_ENGINE;
/
--
-- show errors package WFJ_ENGINE
--      select to_date( 'SQLERROR') from user_errors
--      where type = 'PACKAGE'
--      and name = 'WFJ_ENGINE'
--      /
REM ================================================================

commit;

exit;
