REM dbdrv: sql ~PROD ~PATH ~FILE none none none package &phase=pls \
REM dbdrv: checkfile:~PROD:~PATH:~FILE
--=========================================================================--
--  Copyright (c)2002 Oracle Corporation, Redwood Shores, California, USA  --
--                          All rights reserved.                           --
--=========================================================================--
-- FILENAME
--   WFJMSTXS.pls
--
-- DESCRIPTION
--   Business Event System OJMS Queue Handler.  
--   
-- HISTORY
--   DD-MON-RR  userid    comment
--   28-JAN-02  gashford  Initial version.
--=========================================================================--

set verify off
whenever sqlerror exit failure rollback;
whenever oserror exit failure rollback;

create or replace package wf_event_ojmstext_qh as
/* $Header: wfjmstxs.pls 26.1 2002/08/21 22:28:27 varrajar ship $ */

JMS_TYPE     constant varchar2(8)  := 'JMS_TYPE';
JMS_USERID   constant varchar2(10) := 'JMS_USERID';
JMS_APPID    constant varchar2(9)  := 'JMS_APPID';
JMS_GROUPID  constant varchar2(11) := 'JMS_GROUPID';
JMS_GROUPSEQ constant varchar2(12) := 'JMS_GROUPSEQ';
JMS_REPLYTO  constant varchar2(11) := 'JMS_REPLYTO';

--------------------------------------------------------------------------------
-- Enqueues a business event into a JMS queue.
--
-- p_event - the business event to enqueue
-- p_out_agent_override - the out agent override 
--------------------------------------------------------------------------------
procedure enqueue(p_event              in wf_event_t,
                  p_out_agent_override in wf_agent_t default null);

--------------------------------------------------------------------------------
-- Dequeues a business event from a JMS queue.
--
-- p_agent_guid - the agent GUID
-- p_event - the business event
-- p_wait - the number of seconds to wait to dequeue the event 
--------------------------------------------------------------------------------
procedure dequeue(p_agent_guid in raw,
                  p_event      out nocopy wf_event_t,
                  p_wait       in binary_integer default dbms_aq.no_wait);

--------------------------------------------------------------------------------
-- Tranforms a business event into a JMS Text Message.
--
-- p_event - the business event to transform
-- p_jms_text_message - the JMS Text Message
--------------------------------------------------------------------------------
procedure serialize(p_event            in wf_event_t,
                    p_jms_text_message out nocopy sys.aq$_jms_text_message);
                  
--------------------------------------------------------------------------------
-- Tranforms a JMS Text Message into a business event.
--
-- p_jms_text_message - the JMS Text Message
-- p_event - the business event
--------------------------------------------------------------------------------
procedure deserialize(p_jms_text_message in out sys.aq$_jms_text_message,
                      p_event            out nocopy wf_event_t);

end wf_event_ojmstext_qh;
/
rem show errors package wf_event_ojmstext_qh;
commit;
exit;
